/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.DokitMemoryConfig;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.performance.PerformanceCloseDokitView;
import com.didichuxing.doraemonkit.kit.performance.PerformanceCloseListener;
import com.didichuxing.doraemonkit.kit.performance.PerformanceDokitViewManager;
import com.didichuxing.doraemonkit.kit.performance.PerformanceFragmentCloseListener;
import com.didichuxing.doraemonkit.kit.performance.datasource.DataSourceFactory;
import com.didichuxing.doraemonkit.kit.performance.datasource.IDataSource;
import com.didichuxing.doraemonkit.kit.performance.performanceViewInfo;
import com.didichuxing.doraemonkit.kit.performance.widget.LineChart;
import com.didichuxing.doraemonkit.util.ActivityUtils;

public class PerformanceDokitView
extends AbsDokitView
implements PerformanceCloseListener {
    static final int DEFAULT_REFRESH_INTERVAL = 1000;
    PerformanceCloseDokitView mPerformanceCloseDokitView;
    LinearLayout mPerformanceWrap;
    FrameLayout mFlWrap0;
    FrameLayout mFlWrap1;
    FrameLayout mFlWrap2;
    FrameLayout mFlWrap3;
    LineChart mLineChart0;
    LineChart mLineChart1;
    LineChart mLineChart2;
    LineChart mLineChart3;
    ImageView mIvClose0;
    ImageView mIvClose1;
    ImageView mIvClose2;
    ImageView mIvClose3;
    private PerformanceFragmentCloseListener mPerformanceFragmentCloseListener;

    void addPerformanceFragmentCloseListener(PerformanceFragmentCloseListener listener) {
        this.mPerformanceFragmentCloseListener = listener;
    }

    void removePerformanceFragmentCloseListener(PerformanceFragmentCloseListener listener) {
        if (this.mPerformanceFragmentCloseListener != null && this.mPerformanceFragmentCloseListener == listener) {
            this.mPerformanceFragmentCloseListener = null;
        }
    }

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public View onCreateView(Context context, FrameLayout rootView) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_performance_wrap, (ViewGroup)rootView, false);
    }

    void addItem(int performanceType, String title, int interval) {
        if (this.mPerformanceWrap == null) {
            return;
        }
        int needOperateViewIndex = -1;
        for (int index = 0; index < this.mPerformanceWrap.getChildCount(); ++index) {
            if (this.mPerformanceWrap.getChildAt(index).getVisibility() != 8) continue;
            needOperateViewIndex = index;
            break;
        }
        if (needOperateViewIndex == -1) {
            return;
        }
        FrameLayout needOperateViewWrap = (FrameLayout)this.mPerformanceWrap.getChildAt(needOperateViewIndex);
        needOperateViewWrap.setVisibility(0);
        LineChart needOperateLineChart = (LineChart)needOperateViewWrap.findViewWithTag((Object)"lineChart");
        IDataSource dataSource = DataSourceFactory.createDataSource(performanceType);
        needOperateLineChart.setPerformanceType(performanceType);
        needOperateLineChart.setTitle(title);
        needOperateLineChart.setInterval(interval);
        needOperateLineChart.setDataSource(dataSource);
        needOperateLineChart.startMove();
        if (!this.isNormalMode() && this.mPerformanceCloseDokitView != null) {
            this.mPerformanceCloseDokitView.addItem(needOperateViewIndex, performanceType);
        }
    }

    void removeItem(int performanceType) {
        LineChart needOperateLineChart;
        if (this.mPerformanceWrap == null) {
            return;
        }
        int needOperateViewIndex = -1;
        for (int index = 0; index < this.mPerformanceWrap.getChildCount(); ++index) {
            if (this.mPerformanceWrap.getChildAt(index).getVisibility() == 8 || (needOperateLineChart = (LineChart)this.mPerformanceWrap.getChildAt(index).findViewWithTag((Object)"lineChart")).getPerformanceType() != performanceType) continue;
            needOperateViewIndex = index;
            break;
        }
        if (needOperateViewIndex == -1) {
            return;
        }
        FrameLayout frameLayout = (FrameLayout)this.mPerformanceWrap.getChildAt(needOperateViewIndex);
        frameLayout.setVisibility(8);
        needOperateLineChart = (LineChart)frameLayout.findViewWithTag((Object)"lineChart");
        needOperateLineChart.stopMove();
        needOperateLineChart.setPerformanceType(-1);
        switch (performanceType) {
            case 4: {
                DokitMemoryConfig.FPS_STATUS = false;
                break;
            }
            case 2: {
                DokitMemoryConfig.CPU_STATUS = false;
                break;
            }
            case 3: {
                DokitMemoryConfig.RAM_STATUS = false;
                break;
            }
            case 1: {
                DokitMemoryConfig.NETWORK_STATUS = false;
                break;
            }
        }
        if (!this.isNormalMode() && this.mPerformanceCloseDokitView != null) {
            this.mPerformanceCloseDokitView.removeItem(needOperateViewIndex);
        }
    }

    @Override
    public void onViewCreated(FrameLayout rootView) {
        this.mPerformanceWrap = (LinearLayout)this.findViewById(R.id.ll_performance_wrap);
        this.mFlWrap0 = (FrameLayout)this.findViewById(R.id.fl_chart0);
        this.mFlWrap0.setVisibility(8);
        this.mFlWrap1 = (FrameLayout)this.findViewById(R.id.fl_chart1);
        this.mFlWrap1.setVisibility(8);
        this.mFlWrap2 = (FrameLayout)this.findViewById(R.id.fl_chart2);
        this.mFlWrap2.setVisibility(8);
        this.mFlWrap3 = (FrameLayout)this.findViewById(R.id.fl_chart3);
        this.mFlWrap3.setVisibility(8);
        this.mLineChart0 = (LineChart)((Object)this.findViewById(R.id.linechart0));
        this.mLineChart1 = (LineChart)((Object)this.findViewById(R.id.linechart1));
        this.mLineChart2 = (LineChart)((Object)this.findViewById(R.id.linechart2));
        this.mLineChart3 = (LineChart)((Object)this.findViewById(R.id.linechart3));
        this.mIvClose0 = (ImageView)this.findViewById(R.id.iv_close0);
        this.mIvClose1 = (ImageView)this.findViewById(R.id.iv_close1);
        this.mIvClose2 = (ImageView)this.findViewById(R.id.iv_close2);
        this.mIvClose3 = (ImageView)this.findViewById(R.id.iv_close3);
        this.setDoKitViewNotResponseTouchEvent(this.getDoKitView());
        this.setDoKitViewNotResponseTouchEvent((View)this.mLineChart0);
        this.setDoKitViewNotResponseTouchEvent((View)this.mLineChart1);
        this.setDoKitViewNotResponseTouchEvent((View)this.mLineChart2);
        this.setDoKitViewNotResponseTouchEvent((View)this.mLineChart3);
        if (this.isNormalMode()) {
            this.mIvClose0.setVisibility(0);
            this.mIvClose1.setVisibility(0);
            this.mIvClose2.setVisibility(0);
            this.mIvClose3.setVisibility(0);
        } else {
            this.mIvClose0.setVisibility(8);
            this.mIvClose1.setVisibility(8);
            this.mIvClose2.setVisibility(8);
            this.mIvClose3.setVisibility(8);
        }
        this.mIvClose0.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LineChart lineChart = (LineChart)((FrameLayout)v.getParent()).findViewWithTag((Object)"lineChart");
                PerformanceDokitView.this.onClose(lineChart.getPerformanceType());
            }
        });
        this.mIvClose1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LineChart lineChart = (LineChart)((FrameLayout)v.getParent()).findViewWithTag((Object)"lineChart");
                PerformanceDokitView.this.onClose(lineChart.getPerformanceType());
            }
        });
        this.mIvClose2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LineChart lineChart = (LineChart)((FrameLayout)v.getParent()).findViewWithTag((Object)"lineChart");
                PerformanceDokitView.this.onClose(lineChart.getPerformanceType());
            }
        });
        this.mIvClose3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LineChart lineChart = (LineChart)((FrameLayout)v.getParent()).findViewWithTag((Object)"lineChart");
                PerformanceDokitView.this.onClose(lineChart.getPerformanceType());
            }
        });
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.flags = DokitViewLayoutParams.FLAG_NOT_FOCUSABLE_AND_NOT_TOUCHABLE;
        params.width = DokitViewLayoutParams.MATCH_PARENT;
        params.height = DokitViewLayoutParams.MATCH_PARENT;
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    private void showSystemPerfoemanceCloseDokitView() {
        DoKit.launchFloating(PerformanceCloseDokitView.class);
        this.mPerformanceCloseDokitView = DoKit.getDoKitView(ActivityUtils.getTopActivity(), PerformanceCloseDokitView.class);
        if (this.mPerformanceCloseDokitView != null) {
            this.mPerformanceCloseDokitView.setPerformanceCloseListener(this);
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!this.isNormalMode()) {
            this.showSystemPerfoemanceCloseDokitView();
        }
        if (this.isNormalMode()) {
            this.hideAllPerformanceView();
            for (performanceViewInfo performanceViewInfo2 : PerformanceDokitViewManager.singleperformanceViewInfos.values()) {
                PerformanceDokitViewManager.open(performanceViewInfo2.performanceType, performanceViewInfo2.title, null);
            }
        }
    }

    @Override
    public void onClose(int performanceType) {
        if (performanceType == -1) {
            return;
        }
        if (this.mPerformanceFragmentCloseListener != null) {
            this.mPerformanceFragmentCloseListener.onClose(performanceType);
        }
        PerformanceDokitViewManager.close(performanceType, PerformanceDokitViewManager.getTitleByPerformanceType(this.getContext(), performanceType));
    }

    @Override
    public void onEnterForeground() {
        super.onEnterForeground();
        if (((FrameLayout)this.mLineChart0.getParent()).getVisibility() == 0) {
            this.mLineChart0.startMove();
        }
        if (((FrameLayout)this.mLineChart1.getParent()).getVisibility() == 0) {
            this.mLineChart1.startMove();
        }
        if (((FrameLayout)this.mLineChart2.getParent()).getVisibility() == 0) {
            this.mLineChart2.startMove();
        }
        if (((FrameLayout)this.mLineChart3.getParent()).getVisibility() == 0) {
            this.mLineChart3.startMove();
        }
    }

    @Override
    public void onEnterBackground() {
        super.onEnterBackground();
        this.mLineChart0.stopMove();
        this.mLineChart1.stopMove();
        this.mLineChart2.stopMove();
        this.mLineChart3.stopMove();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mPerformanceFragmentCloseListener = null;
        this.mLineChart0.stopMove();
        this.mLineChart0 = null;
        this.mLineChart1.stopMove();
        this.mLineChart1 = null;
        this.mLineChart2.stopMove();
        this.mLineChart2 = null;
        this.mLineChart3.stopMove();
        this.mLineChart3 = null;
    }

    private void hideAllPerformanceView() {
        if (!this.isNormalMode()) {
            return;
        }
        this.mFlWrap0.setVisibility(8);
        this.mFlWrap1.setVisibility(8);
        this.mFlWrap2.setVisibility(8);
        this.mFlWrap3.setVisibility(8);
    }
}

