/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.Choreographer;
import androidx.annotation.RequiresApi;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.config.DokitMemoryConfig;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.TimeUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class PerformanceDataManager {
    private static final String TAG = "PerformanceDataManager";
    private static final int MAX_FRAME_RATE = 60;
    private static final int NORMAL_SAMPLING_TIME = 500;
    private static final int FPS_SAMPLING_TIME = 1000;
    private String memoryFileName = "memory.txt";
    private String cpuFileName = "cpu.txt";
    private String fpsFileName = "fps.txt";
    private float mLastCpuRate;
    private float mLastMemoryRate;
    private int mLastFrameRate = 60;
    private long mUpBytes;
    private long mDownBytes;
    private long mLastUpBytes;
    private long mLastDownBytes;
    private Handler mNormalHandler;
    private HandlerThread mHandlerThread;
    private float mMaxMemory;
    private Context mContext;
    private ActivityManager mActivityManager;
    private RandomAccessFile mProcStatFile;
    private RandomAccessFile mAppStatFile;
    private Long mLastCpuTime;
    private Long mLastAppCpuTime;
    private boolean mAboveAndroidO;
    private static final int MSG_CPU = 1;
    private static final int MSG_MEMORY = 2;
    private static final int MSG_NET_FLOW = 4;
    private Handler mMainHandler = new Handler(Looper.getMainLooper());
    private FrameRateRunnable mRateRunnable = new FrameRateRunnable();
    public static final int PERFORMANCE_TYPE_CPU = 1;
    public static final int PERFORMANCE_TYPE_MEMORY = 2;
    public static final int PERFORMANCE_TYPE_FPS = 3;

    private void executeCpuData() {
        if (this.mAboveAndroidO) {
            this.mLastCpuRate = this.getCpuDataForO();
            this.writeCpuDataIntoFile();
        } else {
            this.mLastCpuRate = this.getCPUData();
            this.writeCpuDataIntoFile();
        }
    }

    private void executeMemoryData() {
        this.mLastMemoryRate = this.getMemoryData();
        this.writeMemoryDataIntoFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getCpuDataForO() {
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec("top -n 1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int cpuIndex = -1;
            while ((line = reader.readLine()) != null) {
                float rate;
                String[] param;
                if (TextUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                int tempIndex = this.getCPUIndex(line);
                if (tempIndex != -1) {
                    cpuIndex = tempIndex;
                    continue;
                }
                if (!line.startsWith(String.valueOf(android.os.Process.myPid()))) continue;
                if (cpuIndex == -1 || (param = line.split("\\s+")).length <= cpuIndex) continue;
                String cpu = param[cpuIndex];
                if (cpu.endsWith("%")) {
                    cpu = cpu.substring(0, cpu.lastIndexOf("%"));
                }
                float f = rate = Float.parseFloat(cpu) / (float)Runtime.getRuntime().availableProcessors();
                return f;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return 0.0f;
    }

    private int getCPUIndex(String line) {
        if (line.contains("CPU")) {
            String[] titles = line.split("\\s+");
            for (int i = 0; i < titles.length; ++i) {
                if (!titles[i].contains("CPU")) continue;
                return i;
            }
        }
        return -1;
    }

    private PerformanceDataManager() {
    }

    public static PerformanceDataManager getInstance() {
        return Holder.INSTANCE;
    }

    public void init() {
        this.mContext = DoKit.APPLICATION.getApplicationContext();
        this.mActivityManager = (ActivityManager)DoKit.APPLICATION.getSystemService("activity");
        if (Build.VERSION.SDK_INT >= 26) {
            this.mAboveAndroidO = true;
        }
        if (this.mHandlerThread == null) {
            this.mHandlerThread = new HandlerThread("handler-thread");
            this.mHandlerThread.start();
        }
        if (this.mNormalHandler == null) {
            this.mNormalHandler = new Handler(this.mHandlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    if (msg.what == 1) {
                        if (AppUtils.isAppForeground()) {
                            PerformanceDataManager.this.executeCpuData();
                        }
                        PerformanceDataManager.this.mNormalHandler.sendEmptyMessageDelayed(1, 500L);
                    } else if (msg.what == 2) {
                        if (AppUtils.isAppForeground()) {
                            PerformanceDataManager.this.executeMemoryData();
                        }
                        PerformanceDataManager.this.mNormalHandler.sendEmptyMessageDelayed(2, 500L);
                    } else if (msg.what == 4) {
                        PerformanceDataManager.this.mLastUpBytes = NetworkManager.get().getTotalRequestSize() - PerformanceDataManager.this.mUpBytes;
                        PerformanceDataManager.this.mLastDownBytes = NetworkManager.get().getTotalResponseSize() - PerformanceDataManager.this.mDownBytes;
                        PerformanceDataManager.this.mNormalHandler.sendEmptyMessageDelayed(4, 500L);
                    }
                }
            };
        }
    }

    private String getFilePath(Context context) {
        return context.getCacheDir() + File.separator + "doraemon/";
    }

    @RequiresApi(api=16)
    public void startMonitorFrameInfo() {
        DokitMemoryConfig.FPS_STATUS = true;
        this.mMainHandler.postDelayed((Runnable)this.mRateRunnable, 1000L);
        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this.mRateRunnable);
    }

    @RequiresApi(api=16)
    public void stopMonitorFrameInfo() {
        DokitMemoryConfig.FPS_STATUS = false;
        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this.mRateRunnable);
        this.mMainHandler.removeCallbacks((Runnable)this.mRateRunnable);
    }

    public void startMonitorCPUInfo() {
        DokitMemoryConfig.CPU_STATUS = true;
        this.mNormalHandler.sendEmptyMessageDelayed(1, 500L);
    }

    public void startMonitorNetFlowInfo() {
        DokitMemoryConfig.NETWORK_STATUS = true;
        this.mNormalHandler.sendEmptyMessageDelayed(4, 500L);
    }

    public void stopMonitorNetFlowInfo() {
        DokitMemoryConfig.NETWORK_STATUS = false;
        this.mNormalHandler.removeMessages(4);
    }

    public void destroy() {
        this.stopMonitorMemoryInfo();
        this.stopMonitorCPUInfo();
        this.stopMonitorFrameInfo();
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
        }
        this.mHandlerThread = null;
        this.mNormalHandler = null;
    }

    public void stopMonitorCPUInfo() {
        DokitMemoryConfig.CPU_STATUS = false;
        this.mNormalHandler.removeMessages(1);
    }

    public void startMonitorMemoryInfo() {
        DokitMemoryConfig.RAM_STATUS = true;
        if (this.mMaxMemory == 0.0f) {
            this.mMaxMemory = this.mActivityManager.getMemoryClass();
        }
        this.mNormalHandler.sendEmptyMessageDelayed(2, 500L);
    }

    public void stopMonitorMemoryInfo() {
        DokitMemoryConfig.RAM_STATUS = false;
        this.mNormalHandler.removeMessages(2);
    }

    private void writeCpuDataIntoFile() {
        if (DoKitManager.INSTANCE.getCALLBACK() != null) {
            DoKitManager.INSTANCE.getCALLBACK().onCpuCallBack(this.mLastCpuRate, this.getCpuFilePath());
        }
        if (DoKitManager.APP_HEALTH_RUNNING) {
            this.addPerformanceDataInAppHealth(this.mLastCpuRate, 1);
        }
    }

    private void writeMemoryDataIntoFile() {
        if (DoKitManager.INSTANCE.getCALLBACK() != null) {
            DoKitManager.INSTANCE.getCALLBACK().onMemoryCallBack(this.mLastMemoryRate, this.getMemoryFilePath());
        }
        if (DoKitManager.APP_HEALTH_RUNNING) {
            this.addPerformanceDataInAppHealth(this.mLastMemoryRate, 2);
        }
    }

    private void writeFpsDataIntoFile() {
        if (DoKitManager.INSTANCE.getCALLBACK() != null) {
            DoKitManager.INSTANCE.getCALLBACK().onFpsCallBack(this.mLastFrameRate, this.getFpsFilePath());
        }
        if (DoKitManager.APP_HEALTH_RUNNING) {
            this.addPerformanceDataInAppHealth(this.mLastFrameRate > 60 ? 60.0f : (float)this.mLastFrameRate, 3);
        }
    }

    private float getCPUData() {
        float value = 0.0f;
        try {
            if (this.mProcStatFile == null || this.mAppStatFile == null) {
                this.mProcStatFile = new RandomAccessFile("/proc/stat", "r");
                this.mAppStatFile = new RandomAccessFile("/proc/" + android.os.Process.myPid() + "/stat", "r");
            } else {
                this.mProcStatFile.seek(0L);
                this.mAppStatFile.seek(0L);
            }
            String procStatString = this.mProcStatFile.readLine();
            String appStatString = this.mAppStatFile.readLine();
            String[] procStats = procStatString.split(" ");
            String[] appStats = appStatString.split(" ");
            long cpuTime = Long.parseLong(procStats[2]) + Long.parseLong(procStats[3]) + Long.parseLong(procStats[4]) + Long.parseLong(procStats[5]) + Long.parseLong(procStats[6]) + Long.parseLong(procStats[7]) + Long.parseLong(procStats[8]);
            long appTime = Long.parseLong(appStats[13]) + Long.parseLong(appStats[14]);
            if (this.mLastCpuTime == null && this.mLastAppCpuTime == null) {
                this.mLastCpuTime = cpuTime;
                this.mLastAppCpuTime = appTime;
                return value;
            }
            value = (float)(appTime - this.mLastAppCpuTime) / (float)(cpuTime - this.mLastCpuTime) * 100.0f;
            this.mLastCpuTime = cpuTime;
            this.mLastAppCpuTime = appTime;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    private float getMemoryData() {
        float mem = 0.0f;
        try {
            Debug.MemoryInfo memInfo = null;
            if (Build.VERSION.SDK_INT > 28) {
                memInfo = new Debug.MemoryInfo();
                Debug.getMemoryInfo((Debug.MemoryInfo)memInfo);
            } else {
                Debug.MemoryInfo[] memInfos = this.mActivityManager.getProcessMemoryInfo(new int[]{android.os.Process.myPid()});
                if (memInfos != null && memInfos.length > 0) {
                    memInfo = memInfos[0];
                }
            }
            int totalPss = 0;
            if (memInfo != null) {
                totalPss = memInfo.getTotalPss();
            }
            if (totalPss >= 0) {
                mem = (float)totalPss / 1024.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mem;
    }

    private float parseMemoryData(String data) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data.getBytes())));
        while ((line = bufferedReader.readLine()) != null && !(line = line.trim()).contains("Permission Denial")) {
            String[] lineItems = line.split("\\s+");
            if (lineItems == null || lineItems.length <= 1) continue;
            String result2 = lineItems[0];
            bufferedReader.close();
            if (!TextUtils.isEmpty((CharSequence)result2) && result2.contains("K:") && (result2 = result2.replace("K:", "")).contains(",")) {
                result2 = result2.replace(",", ".");
            }
            return Float.parseFloat(result2) / 1024.0f;
        }
        return 0.0f;
    }

    private float parseCPUData(String data) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data.getBytes())));
        while ((line = bufferedReader.readLine()) != null && !(line = line.trim()).contains("Permission Denial")) {
            String[] lineItems = line.split("\\s+");
            if (lineItems == null || lineItems.length <= 1) continue;
            bufferedReader.close();
            return Float.parseFloat(lineItems[0].replace("%", ""));
        }
        return 0.0f;
    }

    public String getCpuFilePath() {
        return this.getFilePath(this.mContext) + this.cpuFileName;
    }

    public String getMemoryFilePath() {
        return this.getFilePath(this.mContext) + this.memoryFileName;
    }

    public String getFpsFilePath() {
        return this.getFilePath(this.mContext) + this.fpsFileName;
    }

    public long getLastFrameRate() {
        return this.mLastFrameRate;
    }

    public float getLastCpuRate() {
        return this.mLastCpuRate;
    }

    public float getLastMemoryInfo() {
        return this.mLastMemoryRate;
    }

    public float getMaxMemory() {
        return this.mMaxMemory;
    }

    public long getLastUpBytes() {
        return this.mLastUpBytes;
    }

    public long getLastDownBytes() {
        return this.mLastDownBytes;
    }

    private synchronized void addPerformanceDataInAppHealth(float performanceValue, int performanceType) {
        if (ActivityUtils.getTopActivity() == null) {
            return;
        }
        try {
            AppHealthInfo.DataBean.PerformanceBean lastPerformanceInfo = AppHealthInfoUtil.getInstance().getLastPerformanceInfo(performanceType);
            if (lastPerformanceInfo == null) {
                AppHealthInfo.DataBean.PerformanceBean performanceBean = new AppHealthInfo.DataBean.PerformanceBean();
                ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> valuesBeans = new ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean>();
                valuesBeans.add(new AppHealthInfo.DataBean.PerformanceBean.ValuesBean("" + TimeUtils.getNowMills(), "" + performanceValue));
                performanceBean.setPage(ActivityUtils.getTopActivity().getClass().getCanonicalName());
                performanceBean.setPageKey(ActivityUtils.getTopActivity().toString());
                performanceBean.setValues(valuesBeans);
                if (performanceType == 1) {
                    AppHealthInfoUtil.getInstance().addCPUInfo(performanceBean);
                } else if (performanceType == 2) {
                    AppHealthInfoUtil.getInstance().addMemoryInfo(performanceBean);
                } else {
                    AppHealthInfoUtil.getInstance().addFPSInfo(performanceBean);
                }
            } else {
                String lastPageKey = lastPerformanceInfo.getPageKey();
                if (ActivityUtils.getTopActivity() != null && lastPageKey.equals(ActivityUtils.getTopActivity().toString())) {
                    List<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> valuesBeans = lastPerformanceInfo.getValues();
                    int valueSize = valuesBeans.size();
                    if (valueSize < 40) {
                        valuesBeans.add(new AppHealthInfo.DataBean.PerformanceBean.ValuesBean("" + TimeUtils.getNowMills(), "" + performanceValue));
                    }
                } else {
                    List<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> lastValuesBeans = lastPerformanceInfo.getValues();
                    int valueSize = lastValuesBeans.size();
                    if (performanceType == 1 && valueSize < 20) {
                        AppHealthInfoUtil.getInstance().removeLastPerformanceInfo(performanceType);
                    } else if (performanceType == 2 && valueSize < 20) {
                        AppHealthInfoUtil.getInstance().removeLastPerformanceInfo(performanceType);
                    } else if (performanceType == 3 && valueSize < 10) {
                        AppHealthInfoUtil.getInstance().removeLastPerformanceInfo(performanceType);
                    }
                    AppHealthInfo.DataBean.PerformanceBean performanceBean = new AppHealthInfo.DataBean.PerformanceBean();
                    ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean> newValuesBeans = new ArrayList<AppHealthInfo.DataBean.PerformanceBean.ValuesBean>();
                    newValuesBeans.add(new AppHealthInfo.DataBean.PerformanceBean.ValuesBean("" + TimeUtils.getNowMills(), "" + performanceValue));
                    performanceBean.setPage(ActivityUtils.getTopActivity().getClass().getCanonicalName());
                    performanceBean.setPageKey(ActivityUtils.getTopActivity().toString());
                    performanceBean.setValues(newValuesBeans);
                    if (performanceType == 1) {
                        AppHealthInfoUtil.getInstance().addCPUInfo(performanceBean);
                    } else if (performanceType == 2) {
                        AppHealthInfoUtil.getInstance().addMemoryInfo(performanceBean);
                    } else {
                        AppHealthInfoUtil.getInstance().addFPSInfo(performanceBean);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FrameRateRunnable
    implements Runnable,
    Choreographer.FrameCallback {
        private int totalFramesPerSecond;

        private FrameRateRunnable() {
        }

        @Override
        public void run() {
            PerformanceDataManager.this.mLastFrameRate = this.totalFramesPerSecond;
            if (PerformanceDataManager.this.mLastFrameRate > 60) {
                PerformanceDataManager.this.mLastFrameRate = 60;
            }
            if (AppUtils.isAppForeground()) {
                PerformanceDataManager.this.writeFpsDataIntoFile();
            }
            this.totalFramesPerSecond = 0;
            PerformanceDataManager.this.mMainHandler.postDelayed((Runnable)this, 1000L);
        }

        public void doFrame(long frameTimeNanos) {
            ++this.totalFramesPerSecond;
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private static class Holder {
        private static PerformanceDataManager INSTANCE = new PerformanceDataManager();

        private Holder() {
        }
    }
}

