/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.bean.WhiteHostBean;
import com.didichuxing.doraemonkit.util.DoKitCommUtil;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.brvah.BaseQuickAdapter;
import com.didichuxing.doraemonkit.widget.brvah.viewholder.BaseViewHolder;
import java.util.List;

public class WhiteHostAdapter
extends BaseQuickAdapter<WhiteHostBean, BaseViewHolder> {
    WhiteHostAdapter(int layoutResId, @Nullable List<WhiteHostBean> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(final @NonNull BaseViewHolder helper, final WhiteHostBean item) {
        if (item.isCanAdd()) {
            ((TextView)helper.getView(R.id.tv_add)).setText((CharSequence)"+");
        } else {
            ((TextView)helper.getView(R.id.tv_add)).setText((CharSequence)"-");
        }
        ((EditText)helper.getView(R.id.ed_host)).setText((CharSequence)item.getHost());
        ((EditText)helper.getView(R.id.ed_host)).addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s != null) {
                    item.setHost(s.toString());
                }
            }
        });
        helper.getView(R.id.fl_add_wrap).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                List hostBeans = WhiteHostAdapter.this.getData();
                String text = ((TextView)helper.getView(R.id.tv_add)).getText().toString();
                if (text.equals("+")) {
                    String editText = ((EditText)helper.getView(R.id.ed_host)).getText().toString();
                    if (TextUtils.isEmpty((CharSequence)editText)) {
                        ToastUtils.showShort((CharSequence)DoKitCommUtil.getString(R.string.dk_kit_net_monitor_white_host_edit_toast));
                        return;
                    }
                    for (WhiteHostBean hostBean : hostBeans) {
                        hostBean.setCanAdd(false);
                    }
                    hostBeans.add(new WhiteHostBean("", true));
                } else {
                    hostBeans.remove(item);
                }
                WhiteHostAdapter.this.notifyDataSetChanged();
            }
        });
    }
}

