/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseActivity;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.OnNetworkInfoUpdateListener;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.ui.NetworkDetailFragment;
import com.didichuxing.doraemonkit.kit.network.ui.NetworkListAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class NetworkListView
extends LinearLayout
implements OnNetworkInfoUpdateListener {
    private static final String TAG = "NetworkListFragment";
    public static final String KEY_RECORD = "record";
    private RecyclerView mNetworkList;
    private NetworkListAdapter mNetworkListAdapter;
    private TextWatcher mTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            NetworkListView.this.mNetworkListAdapter.getFilter().filter((CharSequence)s);
        }
    };

    public NetworkListView(Context context) {
        super(context);
        NetworkListView.inflate((Context)context, (int)R.layout.dk_fragment_network_monitor_list, (ViewGroup)this);
        this.initView();
        this.initData();
    }

    public NetworkListView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        NetworkListView.inflate((Context)context, (int)R.layout.dk_fragment_network_monitor_list, (ViewGroup)this);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mNetworkList = (RecyclerView)this.findViewById(R.id.network_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mNetworkList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mNetworkListAdapter = new NetworkListAdapter(this.getContext());
        this.mNetworkList.setAdapter((RecyclerView.Adapter)this.mNetworkListAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        decoration.showHeaderDivider(true);
        this.mNetworkList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mNetworkListAdapter.setOnItemClickListener(new NetworkListAdapter.OnItemClickListener(){

            @Override
            public void onClick(NetworkRecord record) {
                Bundle bundle = new Bundle();
                bundle.putSerializable(NetworkListView.KEY_RECORD, (Serializable)record);
                ((BaseActivity)NetworkListView.this.getContext()).showContent(NetworkDetailFragment.class, bundle);
            }
        });
        ((EditText)this.findViewById(R.id.network_list_filter)).addTextChangedListener(this.mTextWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        NetworkListView networkListView = this;
        synchronized (networkListView) {
            ArrayList<NetworkRecord> records = new ArrayList<NetworkRecord>(NetworkManager.get().getRecords());
            Collections.reverse(records);
            this.mNetworkListAdapter.setData((Collection<NetworkRecord>)records);
        }
    }

    public void registerNetworkListener() {
        NetworkManager.get().setOnNetworkInfoUpdateListener(this);
    }

    public void unRegisterNetworkListener() {
        NetworkManager.get().setOnNetworkInfoUpdateListener(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNetworkInfoUpdate(NetworkRecord record, boolean add) {
        NetworkListView networkListView = this;
        synchronized (networkListView) {
            if (add) {
                this.mNetworkListAdapter.append(record, 0);
            }
            this.mNetworkListAdapter.notifyDataSetChanged();
        }
    }
}

