/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.bean.Request;
import com.didichuxing.doraemonkit.kit.network.bean.Response;
import com.didichuxing.doraemonkit.kit.network.utils.ByteUtil;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class NetworkListAdapter
extends AbsRecyclerAdapter<AbsViewBinder<NetworkRecord>, NetworkRecord>
implements Filterable {
    private OnItemClickListener mListener;
    private List<NetworkRecord> mSourceList = new ArrayList<NetworkRecord>();
    private Filter mFilter = new Filter(){

        protected Filter.FilterResults performFiltering(CharSequence constraint) {
            String charString = constraint.toString();
            List<NetworkRecord> filteredList = new ArrayList();
            if (charString.isEmpty()) {
                filteredList = NetworkListAdapter.this.mSourceList;
            } else {
                for (NetworkRecord record : NetworkListAdapter.this.mSourceList) {
                    if (!record.filter(charString)) continue;
                    filteredList.add(record);
                }
            }
            Filter.FilterResults filterResults = new Filter.FilterResults();
            filterResults.values = filteredList;
            return filterResults;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            List filteredList = (List)results.values;
            if (filteredList == null || filteredList.size() == 0) {
                NetworkListAdapter.this.clear();
            } else {
                NetworkListAdapter.super.setData(filteredList);
            }
            NetworkListAdapter.this.notifyDataSetChanged();
        }
    };

    public NetworkListAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<NetworkRecord> createViewHolder(View view, int viewType) {
        return new ItemViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_network_list, parent, false);
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    @Override
    public void setData(Collection<NetworkRecord> items) {
        this.mSourceList.clear();
        this.mSourceList.addAll(items);
        super.setData(items);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public static interface OnItemClickListener {
        public void onClick(NetworkRecord var1);
    }

    private class ItemViewHolder
    extends AbsViewBinder<NetworkRecord> {
        private static final String METHOD_FORMAT = "%s>%s";
        private static final String FLOW_FORMAT = "\u2191 %s \u2193%s";
        private static final String CODE_FORMAT = "[%d]";
        private static final String UNKNOWN = "unknown";
        private TextView url;
        private TextView platform;
        private TextView method;
        private TextView code;
        private TextView time;
        private TextView flow;
        private SimpleDateFormat mDateFormat;

        public ItemViewHolder(View view) {
            super(view);
            this.mDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS");
        }

        @Override
        protected void getViews() {
            this.url = (TextView)this.getView(R.id.network_list_url);
            this.platform = (TextView)this.getView(R.id.network_list_platform);
            this.method = (TextView)this.getView(R.id.network_list_method);
            this.code = (TextView)this.getView(R.id.network_list_code);
            this.time = (TextView)this.getView(R.id.network_list_time_and_cost);
            this.flow = (TextView)this.getView(R.id.network_list_flow);
        }

        @Override
        public void bind(final NetworkRecord record) {
            Request request2;
            if (record.mRequest != null) {
                request2 = record.mRequest;
                this.url.setText((CharSequence)request2.url);
                String cost = record.endTime < record.startTime ? UNKNOWN : (float)(record.endTime - record.startTime) / 1000.0f + "s";
                String startTime = this.mDateFormat.format(new Date(record.startTime));
                this.time.setText((CharSequence)this.getContext().getString(R.string.dk_kit_network_time_format, new Object[]{startTime, cost}));
            } else {
                this.url.setText((CharSequence)UNKNOWN);
                this.time.setText((CharSequence)this.getContext().getString(R.string.dk_kit_network_time_format, new Object[]{UNKNOWN, UNKNOWN}));
            }
            if (record.mResponse != null && record.mRequest != null) {
                request2 = record.mRequest;
                Response response = record.mResponse;
                this.method.setText((CharSequence)String.format(METHOD_FORMAT, request2.method, response.mimeType));
                this.code.setText((CharSequence)String.format(CODE_FORMAT, response.status));
            } else {
                this.code.setText((CharSequence)UNKNOWN);
                this.method.setText((CharSequence)UNKNOWN);
            }
            this.platform.setText((CharSequence)String.format("platform: %s", record.mPlatform));
            this.flow.setText((CharSequence)String.format(FLOW_FORMAT, ByteUtil.getPrintSize(record.requestLength), ByteUtil.getPrintSize(record.responseLength)));
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NetworkListAdapter.this.mListener != null) {
                        NetworkListAdapter.this.mListener.onClick(record);
                    }
                }
            });
        }
    }
}

