/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.ui.NetworkDetailView;
import com.didichuxing.doraemonkit.kit.network.ui.NetworkPagerAdapter;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.util.ArrayList;

public class NetworkDetailFragment
extends BaseFragment
implements View.OnClickListener {
    private static final String TAG = "NetworkDetailFragment";
    private ViewPager mViewPager;
    private View mDiverRequest;
    private View mDiverResponse;
    private TextView mTvRequest;
    private TextView mTvResponse;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_network_monitor_detail;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    private void initView() {
        this.mViewPager = (ViewPager)this.findViewById(R.id.network_viewpager);
        this.mDiverRequest = this.findViewById(R.id.diver_request);
        this.mDiverResponse = this.findViewById(R.id.diver_response);
        this.mTvRequest = (TextView)this.findViewById(R.id.tv_pager_request);
        this.mTvResponse = (TextView)this.findViewById(R.id.tv_pager_response);
        this.mTvRequest.setSelected(true);
        this.mTvResponse.setSelected(false);
        this.mTvRequest.setOnClickListener((View.OnClickListener)this);
        this.mTvResponse.setOnClickListener((View.OnClickListener)this);
        ArrayList<NetworkDetailView> views = new ArrayList<NetworkDetailView>();
        Bundle bundle = this.getArguments();
        NetworkRecord record = (NetworkRecord)bundle.getSerializable("record");
        views.add(new NetworkDetailView(this.getContext()));
        views.add(new NetworkDetailView(this.getContext()));
        NetworkPagerAdapter adapter = new NetworkPagerAdapter(views, record);
        this.mViewPager.setAdapter((PagerAdapter)adapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                NetworkDetailFragment.this.mDiverRequest.setVisibility(position == 0 ? 0 : 8);
                NetworkDetailFragment.this.mDiverResponse.setVisibility(position == 1 ? 0 : 8);
                NetworkDetailFragment.this.mTvRequest.setSelected(position == 0);
                NetworkDetailFragment.this.mTvResponse.setSelected(position == 1);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        TitleBar mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                NetworkDetailFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        return super.onBackPressed();
    }

    public void onResume() {
        super.onResume();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_pager_request) {
            this.mViewPager.setCurrentItem(0, true);
        } else if (v.getId() == R.id.tv_pager_response) {
            this.mViewPager.setCurrentItem(1, true);
        }
    }
}

