/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.utils.ByteUtil;
import com.didichuxing.doraemonkit.kit.network.utils.CostTimeUtil;
import com.didichuxing.doraemonkit.widget.chart.BarChart;
import com.didichuxing.doraemonkit.widget.chart.PieChart;
import java.util.ArrayList;

public class NetWorkSummaryView
extends LinearLayout {
    public NetWorkSummaryView(Context context) {
        super(context);
        NetWorkSummaryView.inflate((Context)context, (int)R.layout.dk_fragment_network_summary_page, (ViewGroup)this);
        this.initView();
    }

    public NetWorkSummaryView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        NetWorkSummaryView.inflate((Context)context, (int)R.layout.dk_fragment_network_summary_page, (ViewGroup)this);
        this.initView();
    }

    private void initView() {
        TextView totalSec = (TextView)this.findViewById(R.id.total_sec);
        TextView totalNumber = (TextView)this.findViewById(R.id.total_number);
        TextView totalUpload = (TextView)this.findViewById(R.id.total_upload);
        TextView totalDown = (TextView)this.findViewById(R.id.total_down);
        int postCount = NetworkManager.get().getPostCount();
        int getCount = NetworkManager.get().getGetCount();
        int totalCount = NetworkManager.get().getTotalCount();
        totalNumber.setText((CharSequence)String.valueOf(totalCount));
        long time = NetworkManager.get().getRunningTime();
        totalSec.setText((CharSequence)CostTimeUtil.formatTime(this.getContext(), time));
        long requestSize = NetworkManager.get().getTotalRequestSize();
        long responseSize = NetworkManager.get().getTotalResponseSize();
        totalUpload.setText((CharSequence)ByteUtil.getPrintSizeForSpannable(requestSize));
        totalDown.setText((CharSequence)ByteUtil.getPrintSizeForSpannable(responseSize));
        PieChart chart = (PieChart)this.findViewById(R.id.network_pier_chart);
        ArrayList<PieChart.PieData> data = new ArrayList<PieChart.PieData>();
        Resources resource = this.getResources();
        if (postCount != 0) {
            data.add(new PieChart.PieData(resource.getColor(R.color.dk_color_55A8FD), postCount));
        }
        if (getCount != 0) {
            data.add(new PieChart.PieData(resource.getColor(R.color.dk_color_FAD337), getCount));
        }
        chart.setData(data);
        BarChart barChart = (BarChart)this.findViewById(R.id.network_bar_chart);
        barChart.setData(postCount, this.getResources().getColor(R.color.dk_color_55A8FD), getCount, this.getResources().getColor(R.color.dk_color_FAD337));
    }
}

