/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.network.ui.NetWorkMainPagerAdapter;
import com.didichuxing.doraemonkit.kit.network.ui.NetWorkSummaryView;
import com.didichuxing.doraemonkit.kit.network.ui.NetworkListView;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.util.ArrayList;

public class NetWorkMainPagerFragment
extends BaseFragment
implements View.OnClickListener {
    private ViewPager mViewPager;
    private NetWorkSummaryView mSummaryView;
    private NetworkListView mNetworkListView;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_net_main_pager;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        TitleBar mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                NetWorkMainPagerFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
        this.mViewPager = (ViewPager)this.findViewById(R.id.vp_show);
        this.mSummaryView = new NetWorkSummaryView(this.getContext());
        this.mNetworkListView = new NetworkListView(this.getContext());
        this.mNetworkListView.registerNetworkListener();
        ArrayList<View> views = new ArrayList<View>();
        views.add((View)this.mSummaryView);
        views.add((View)this.mNetworkListView);
        this.mViewPager.setAdapter((PagerAdapter)new NetWorkMainPagerAdapter(this.getContext(), views));
        Object tabSummary = this.findViewById(R.id.tab_summary);
        ((TextView)tabSummary.findViewById(R.id.tab_text)).setText(R.string.dk_net_monitor_title_summary);
        ((ImageView)tabSummary.findViewById(R.id.tab_icon)).setImageResource(R.drawable.dk_net_work_monitor_summary_selector);
        tabSummary.setSelected(true);
        tabSummary.setOnClickListener((View.OnClickListener)this);
        Object tabList = this.findViewById(R.id.tab_list);
        ((TextView)tabList.findViewById(R.id.tab_text)).setText(R.string.dk_net_monitor_list);
        ((ImageView)tabList.findViewById(R.id.tab_icon)).setImageResource(R.drawable.dk_net_work_monitor_list_selector);
        tabList.setOnClickListener((View.OnClickListener)this);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener((View)tabSummary, (View)tabList){
            final /* synthetic */ View val$tabSummary;
            final /* synthetic */ View val$tabList;
            {
                this.val$tabSummary = view;
                this.val$tabList = view2;
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (position == 0) {
                    this.val$tabSummary.setSelected(true);
                    this.val$tabList.setSelected(false);
                } else {
                    this.val$tabList.setSelected(true);
                    this.val$tabSummary.setSelected(false);
                }
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tab_summary) {
            this.mViewPager.setCurrentItem(0, true);
        } else if (id2 == R.id.tab_list) {
            this.mViewPager.setCurrentItem(1, true);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mNetworkListView != null) {
            this.mNetworkListView.unRegisterNetworkListener();
        }
    }
}

