/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.stream;

import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import com.didichuxing.doraemonkit.kit.network.core.RequestBodyHelper;
import com.didichuxing.doraemonkit.kit.network.stream.OutputStreamProxy;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutputStreamProxy
extends OutputStreamProxy {
    private final int mRequestId;
    private final NetworkInterpreter mInterpreter;

    public HttpOutputStreamProxy(OutputStream out, int requestId, NetworkInterpreter interpreter) {
        super(out);
        this.mRequestId = requestId;
        this.mInterpreter = interpreter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onStreamComplete() throws IOException {
        NetworkRecord record = NetworkManager.get().getRecord(this.mRequestId);
        if (record != null && record.mRequest != null) {
            RequestBodyHelper requestBodyHelper = new RequestBodyHelper();
            try {
                OutputStream out = requestBodyHelper.createBodySink(record.mRequest.encode);
                this.mOutputStream.writeTo(out);
            }
            finally {
                this.out.close();
            }
            byte[] body = requestBodyHelper.getDisplayBody();
            this.mInterpreter.fetRequestBody(record, body);
        }
    }
}

