/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo.util;

import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.loginfo.util.ArrayUtil;
import java.util.ArrayList;

public class StringUtil {
    public static String padLeft(String input, int size) {
        if (input.length() > size) {
            throw new IllegalArgumentException("input must be shorter than or equal to the number of spaces: " + size);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = input.length(); i < size; ++i) {
            sb.append(" ");
        }
        return sb.append(input).toString();
    }

    public static String[] split(String str, String delimiter) {
        ArrayList<String> result2 = new ArrayList<String>();
        int lastIndex = 0;
        int index = str.indexOf(delimiter);
        while (index != -1) {
            result2.add(str.substring(lastIndex, index));
            lastIndex = index + delimiter.length();
            index = str.indexOf(delimiter, index + delimiter.length());
        }
        result2.add(str.substring(lastIndex, str.length()));
        return ArrayUtil.toArray(result2, String.class);
    }

    public static String replace(String originalString, String searchString, String replaceString) {
        StringBuilder sb = new StringBuilder(originalString);
        int index = sb.indexOf(searchString);
        while (index != -1) {
            sb.replace(index, index + searchString.length(), replaceString);
            index += replaceString.length();
            index = sb.indexOf(searchString, index);
        }
        return sb.toString();
    }

    public static String join(String delimiter, String[] strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String str : strings) {
            stringBuilder.append(" ").append(str);
        }
        return stringBuilder.substring(1);
    }

    public static int computeLevenshteinDistance(CharSequence str1, CharSequence str2) {
        int i;
        int commonPrefixLength = StringUtil.findCommonPrefixLength(str1, str2);
        if (commonPrefixLength == str1.length() && commonPrefixLength == str2.length()) {
            return 0;
        }
        int commonSuffixLength = StringUtil.findCommonSuffixLength(str1, str2, commonPrefixLength);
        str1 = str1.subSequence(commonPrefixLength, str1.length() - commonSuffixLength);
        str2 = str2.subSequence(commonPrefixLength, str2.length() - commonSuffixLength);
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                distance[i][j] = StringUtil.minimum(distance[i - 1][j] + 1, distance[i][j - 1] + 1, distance[i - 1][j - 1] + (str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1));
            }
        }
        return distance[str1.length()][str2.length()];
    }

    private static int findCommonPrefixLength(CharSequence str1, CharSequence str2) {
        int length = Math.min(str1.length(), str2.length());
        for (int i = 0; i < length; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return i;
        }
        return 0;
    }

    private static int findCommonSuffixLength(CharSequence str1, CharSequence str2, int commonPrefixLength) {
        int length = Math.min(str1.length(), str2.length());
        for (int i = 0; i < length - commonPrefixLength; ++i) {
            if (str1.charAt(str1.length() - i - 1) == str2.charAt(str2.length() - i - 1)) continue;
            return i;
        }
        return 0;
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static String join(int[] arr, String delimiter) {
        if (arr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i : arr) {
            sb.append(delimiter).append(Integer.toString(i));
        }
        return sb.substring(delimiter.length());
    }

    public static String capitalize(String str) {
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && !Character.isWhitespace(sb.charAt(i - 1))) continue;
            sb.replace(i, i + 1, Character.toString(Character.toUpperCase(sb.charAt(i))));
        }
        return sb.toString();
    }

    public static String nullToEmpty(CharSequence str) {
        return str == null ? "" : str.toString();
    }

    public static boolean isEmptyOrWhitespaceOnly(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(String str, String query) {
        if (str != null && query != null) {
            int limit = str.length() - query.length() + 1;
            for (int i = 0; i < limit; ++i) {
                if (!StringUtil.matchesIgnoreCase(str, query, i)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchesIgnoreCase(String str, String query, int startingAt) {
        int len = query.length();
        for (int i = 0; i < len; ++i) {
            if (Character.toUpperCase(query.charAt(i)) == Character.toUpperCase(str.charAt(startingAt + i))) continue;
            return false;
        }
        return true;
    }
}

