/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo.util;

import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.loginfo.LogLine;
import com.didichuxing.doraemonkit.kit.loginfo.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchCriteria {
    public static final String PID_KEYWORD = "pid:";
    public static final String TAG_KEYWORD = "tag:";
    private static final Pattern PID_PATTERN = Pattern.compile("pid:(\\d+)", 2);
    private static final Pattern TAG_PATTERN = Pattern.compile("tag:(\"[^\"]+\"|\\S+)", 2);
    private int pid = -1;
    private String tag;
    private String searchText;
    private int searchTextAsInt = -1;

    public SearchCriteria(CharSequence inputQuery) {
        Matcher tagMatcher;
        StringBuilder query = new StringBuilder(StringUtil.nullToEmpty(inputQuery));
        Matcher pidMatcher = PID_PATTERN.matcher(query);
        if (pidMatcher.find()) {
            try {
                this.pid = Integer.parseInt(pidMatcher.group(1));
                query.replace(pidMatcher.start(), pidMatcher.end(), "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((tagMatcher = TAG_PATTERN.matcher(query)).find()) {
            this.tag = tagMatcher.group(1);
            if (this.tag.startsWith("\"") && this.tag.endsWith("\"")) {
                this.tag = this.tag.substring(1, this.tag.length() - 1);
            }
            query.replace(tagMatcher.start(), tagMatcher.end(), "");
        }
        this.searchText = query.toString().trim();
        try {
            this.searchTextAsInt = Integer.parseInt(this.searchText);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isEmpty() {
        return this.pid == -1 && TextUtils.isEmpty((CharSequence)this.tag) && TextUtils.isEmpty((CharSequence)this.searchText);
    }

    public boolean matches(LogLine logLine) {
        if (!this.checkFoundPid(logLine)) {
            return false;
        }
        if (!this.checkFoundTag(logLine)) {
            return false;
        }
        return this.checkFoundText(logLine);
    }

    private boolean checkFoundText(LogLine logLine) {
        return TextUtils.isEmpty((CharSequence)this.searchText) || this.searchTextAsInt != -1 && this.searchTextAsInt == logLine.getProcessId() || logLine.getTag() != null && StringUtil.containsIgnoreCase(logLine.getTag(), this.searchText) || logLine.getLogOutput() != null && StringUtil.containsIgnoreCase(logLine.getLogOutput(), this.searchText);
    }

    private boolean checkFoundTag(LogLine logLine) {
        return TextUtils.isEmpty((CharSequence)this.tag) || logLine.getTag() != null && StringUtil.containsIgnoreCase(logLine.getTag(), this.tag);
    }

    private boolean checkFoundPid(LogLine logLine) {
        return this.pid == -1 || logLine.getProcessId() == this.pid;
    }
}

