/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.LogInfoConfig;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.SettingItem;
import com.didichuxing.doraemonkit.kit.core.SettingItemAdapter;
import com.didichuxing.doraemonkit.kit.loginfo.LogInfoDokitView;
import com.didichuxing.doraemonkit.kit.loginfo.LogInfoManager;
import com.didichuxing.doraemonkit.widget.titlebar.HomeTitleBar;

public class LogInfoSettingFragment
extends BaseFragment {
    private static final String TAG = "LogInfoSettingFragment";
    private RecyclerView mSettingList;
    private SettingItemAdapter mSettingItemAdapter;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        HomeTitleBar titleBar = (HomeTitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setListener(new HomeTitleBar.OnTitleBarClickListener(){

            @Override
            public void onRightClick() {
                LogInfoSettingFragment.this.finish();
            }
        });
        this.mSettingList = (RecyclerView)this.findViewById(R.id.setting_list);
        this.mSettingList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mSettingItemAdapter = new SettingItemAdapter(this.getContext());
        this.mSettingItemAdapter.append(new SettingItem(R.string.dk_kit_log_info, LogInfoConfig.isLogInfoOpen()));
        this.mSettingItemAdapter.setOnSettingItemSwitchListener(new SettingItemAdapter.OnSettingItemSwitchListener(){

            @Override
            public void onSettingItemSwitch(View view, SettingItem data, boolean on) {
                if (data.desc == R.string.dk_kit_log_info) {
                    if (on) {
                        DoKit.launchFloating(LogInfoDokitView.class);
                        LogInfoManager.getInstance().start();
                    } else {
                        DoKit.removeFloating(LogInfoDokitView.class);
                        LogInfoManager.getInstance().stop();
                        LogInfoManager.getInstance().removeListener();
                    }
                    LogInfoConfig.setLogInfoOpen(on);
                }
            }
        });
        this.mSettingList.setAdapter((RecyclerView.Adapter)this.mSettingItemAdapter);
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_log_info_setting;
    }
}

