/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.lbs.route;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import com.didichuxing.doraemonkit.kit.lbs.common.LocInfo;
import com.didichuxing.doraemonkit.kit.lbs.manual.FloatGpsMockCache;
import com.didichuxing.doraemonkit.kit.lbs.preset.FloatGpsPresetMockCache;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class FloatGpsRouteMockCache {
    private static final String TAG = "EnvironmentKit";
    private static List<Pair<Double, Double>> sMockRoute;
    private static int sMockRouteIndex;
    private static Handler sHandler;
    private static Timer sTimer;
    private static IOnRouteChange sIOnRouteChange;

    public static LocInfo getCurrentLocConfig() {
        return FloatGpsPresetMockCache.getMockLocConfig();
    }

    public static void mockGpsRoute(Context context, List<Pair<Double, Double>> routes) {
        sMockRoute = routes;
        FloatGpsRouteMockCache.restartPlayMockRoute(context);
        if (sIOnRouteChange != null) {
            sIOnRouteChange.onRouteChange();
        }
    }

    public static void restartPlayMockRoute(Context context) {
        if (sMockRoute == null || sMockRoute.size() == 0) {
            return;
        }
        sMockRouteIndex = 0;
        FloatGpsRouteMockCache.resumePlayMockRoute(context);
    }

    public static void resumePlayMockRoute(Context context) {
        if (sTimer != null) {
            sTimer.cancel();
        }
        sTimer = new Timer();
        final Context finalContext = context;
        sTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (sMockRoute != null && sMockRoute.size() > sMockRouteIndex) {
                    FloatGpsRouteMockCache.setMockRouteProgress(finalContext, sMockRouteIndex);
                    sMockRouteIndex++;
                } else {
                    sTimer.cancel();
                }
            }
        }, 0L, 500L);
    }

    public static void pausePlayMockRoute() {
        if (sTimer != null) {
            sTimer.cancel();
        }
    }

    public static void clearMockRoute() {
        if (sTimer != null) {
            sTimer.cancel();
            sMockRouteIndex = 0;
            if (sMockRoute != null) {
                sMockRoute.clear();
            }
        }
    }

    public static int getMockRouteProgress() {
        return sMockRouteIndex;
    }

    public static int getRouteCount() {
        return sMockRoute == null ? 0 : sMockRoute.size();
    }

    public static int setMockRouteProgress(Context context, int index) {
        if (FloatGpsRouteMockCache.getRouteCount() > index && index > 0) {
            sMockRouteIndex = index;
            Pair<Double, Double> mockRoutePoint = sMockRoute.get(index);
            FloatGpsMockCache.mockToLocation((Double)mockRoutePoint.first, (Double)mockRoutePoint.second);
            if (sIOnRouteChange != null) {
                sIOnRouteChange.onIndexChange(sMockRouteIndex);
            }
        }
        return sMockRouteIndex;
    }

    public static void setRouteChangeListener(IOnRouteChange onRouteChange) {
        sIOnRouteChange = onRouteChange;
    }

    static {
        sMockRouteIndex = 0;
        sHandler = new Handler(Looper.getMainLooper());
    }

    public static interface IOnRouteChange {
        public void onRouteChange();

        public void onIndexChange(int var1);
    }
}

