/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.lbs.manual;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.Switch;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockManager;
import com.didichuxing.doraemonkit.kit.lbs.common.LocInfo;
import com.didichuxing.doraemonkit.kit.lbs.manual.FloatGpsMockCache;
import com.didichuxing.doraemonkit.kit.lbs.manual.GPSTools;
import com.didichuxing.doraemonkit.kit.lbs.route.FloatGpsRouteMockCache;
import com.didichuxing.doraemonkit.util.ToastUtils;

public class PosAdjustKitView
extends AbsDokitView {
    public static final String TAG = "FloatGpsMockKitView";
    public static final int MIN_STEP = 5;
    public static final int MAX_STEP = 500;
    private View mRootView;
    private static int sMockStep = 10;
    private TextView mMockSpeedTv;
    private SeekBar mSpeedSeekBar;
    private TextView mEnvInfo = null;

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public View onCreateView(Context context, FrameLayout rootView) {
        return LayoutInflater.from((Context)context).inflate(R.layout.layout_mock_pos_adjust, (ViewGroup)rootView, false);
    }

    @Override
    public void onViewCreated(FrameLayout rootView) {
        this.mRootView = rootView;
        this.setMockLocationConfig();
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.width = DokitViewLayoutParams.WRAP_CONTENT;
        params.height = DokitViewLayoutParams.WRAP_CONTENT;
        params.gravity = 51;
        params.x = 200;
        params.y = 200;
    }

    private void setMockLocationConfig() {
        Switch envSwitch = (Switch)this.findViewById(R.id.env_switch3);
        envSwitch.setChecked(GpsMockManager.getInstance().isMocking());
        envSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean on) {
                if (on) {
                    GpsMockManager.getInstance().startMock();
                } else {
                    GpsMockManager.getInstance().stopMock();
                }
            }
        });
        this.mMockSpeedTv = (TextView)this.findViewById(R.id.tv_mock_speed);
        this.mSpeedSeekBar = (SeekBar)this.findViewById(R.id.dk_sb_seekBar);
        this.updateSpeedView(this.mMockSpeedTv, this.mSpeedSeekBar);
        if (Build.VERSION.SDK_INT >= 26) {
            this.mSpeedSeekBar.setMin(5);
        }
        this.mSpeedSeekBar.setMax(500);
        this.mSpeedSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    sMockStep = progress;
                    PosAdjustKitView.this.mMockSpeedTv.setText((CharSequence)String.format("\u6b65\u8fdb\u901f\u5ea6\u63a7\u5236:%s\u7c73", sMockStep));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.findViewById(R.id.dk_btn_downMockSpeed).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                sMockStep = sMockStep - 10;
                if (sMockStep < 5) {
                    sMockStep = 5;
                }
                PosAdjustKitView.this.updateSpeedView(PosAdjustKitView.this.mMockSpeedTv, PosAdjustKitView.this.mSpeedSeekBar);
            }
        });
        this.findViewById(R.id.dk_btn_upMockSpeed).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                sMockStep = sMockStep + 10;
                if (sMockStep > 500) {
                    sMockStep = 500;
                }
                PosAdjustKitView.this.updateSpeedView(PosAdjustKitView.this.mMockSpeedTv, PosAdjustKitView.this.mSpeedSeekBar);
            }
        });
        this.mEnvInfo = (TextView)this.findViewById(R.id.env_info3);
        this.mEnvInfo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PosAdjustKitView.this.copyToClipboard(PosAdjustKitView.this.mEnvInfo.getText().toString());
            }
        });
    }

    private void updateSpeedView(TextView mockSpeed, SeekBar seekBar) {
        seekBar.setProgress(sMockStep);
        this.mMockSpeedTv.setText((CharSequence)String.format("\u6b65\u8fdb\u901f\u5ea6\u63a7\u5236:%s\u7c73", sMockStep));
    }

    private void updateCurrentLocConfig(LocInfo currentConfig) {
        if (this.mEnvInfo == null) {
            return;
        }
        this.updateGsonInfo(currentConfig.toString(), this.mEnvInfo);
    }

    private void updateGsonInfo(String currentConfig, TextView envInfo) {
        if (currentConfig == null) {
            envInfo.setVisibility(8);
        } else {
            envInfo.setVisibility(0);
            envInfo.setText((CharSequence)currentConfig);
        }
    }

    private void moveMockLocation(int latDistance, int lngDistance) {
        try {
            ((Switch)this.findViewById(R.id.env_switch3)).setChecked(true);
            FloatGpsMockCache.mockToLocation(GpsMockManager.getInstance().getLatitude() + GPSTools.getLatDiff(latDistance), GpsMockManager.getInstance().getLongitude() + GPSTools.getLngDiff(GpsMockManager.getInstance().getLatitude(), lngDistance));
            this.updateCurrentLocConfig(FloatGpsRouteMockCache.getCurrentLocConfig());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void copyToClipboard(String s) {
        ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
        String label = "\u5df2\u62f7\u8d1d\u503c\u526a\u5207\u677f\uff0c\u53ef\u4ee5\u5230\u522b\u7684\u5730\u65b9\u76f4\u63a5\u7c98\u8d34\u4f7f\u7528\u4e86";
        ToastUtils.showShort((CharSequence)label);
        ClipData clip = ClipData.newPlainText((CharSequence)label, (CharSequence)s);
        clipboard.setPrimaryClip(clip);
    }
}

