/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.lbs.common;

import android.util.ArrayMap;
import com.didichuxing.doraemonkit.kit.lbs.common.Constants;
import java.util.Arrays;

public class LocInfo {
    public String locName;
    public double lat;
    public double lng;
    public ArrayMap<String, Object> extra;

    public LocInfo(String locName, double lat, double lng) {
        this.locName = locName;
        this.lat = lat;
        this.lng = lng;
    }

    public static LocInfo fromGson(String gsonStr) {
        return (LocInfo)Constants.GSON.fromJson(gsonStr, LocInfo.class);
    }

    public ArrayMap<String, Object> getExtra() {
        return this.extra;
    }

    public LocInfo setExtra(ArrayMap extra) {
        this.extra = extra;
        return this;
    }

    public LocInfo putExtra(String key, Object value) {
        if (this.extra == null) {
            this.extra = new ArrayMap();
        }
        this.extra.put((Object)key, value);
        return this;
    }

    public Object getExtra(String key) {
        if (this.extra != null && this.extra.containsKey((Object)key)) {
            return this.extra.get((Object)key);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocInfo locInfo = (LocInfo)o;
        return Double.compare(locInfo.lat, this.lat) == 0 && Double.compare(locInfo.lng, this.lng) == 0 && LocInfo.isEquals(this.locName, locInfo.locName);
    }

    public static boolean isEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.locName, this.lat, this.lng});
    }

    public String toString() {
        return String.format("%s\n\u7eac:%s, \u7ecf:%s", this.locName, this.lat, this.lng);
    }

    public String toGson() {
        return Constants.GSON.toJson((Object)this);
    }
}

