/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.layoutborder;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.LayoutBorderConfig;
import com.didichuxing.doraemonkit.kit.core.DokitViewInterface;
import com.didichuxing.doraemonkit.kit.layoutborder.ViewBorderDrawable;
import java.util.ArrayList;

public class ViewBorderFrameLayout
extends FrameLayout {
    private static final String TAG = "ViewBorderFrameLayout";

    public ViewBorderFrameLayout(@NonNull Context context) {
        super(context);
        this.setId(R.id.dokit_view_border_id);
    }

    public ViewBorderFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setId(R.id.dokit_view_border_id);
    }

    public ViewBorderFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setId(R.id.dokit_view_border_id);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (LayoutBorderConfig.isLayoutBorderOpen()) {
            this.traverseChild((View)this);
        } else {
            this.clearChild((View)this);
        }
    }

    private void traverseChild(View view) {
        if (view instanceof ViewGroup && !(view instanceof DokitViewInterface)) {
            this.replaceDrawable(view);
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = 0; index < childCount; ++index) {
                    this.traverseChild(((ViewGroup)view).getChildAt(index));
                }
            }
        } else {
            this.replaceDrawable(view);
        }
    }

    private void replaceDrawable(View view) {
        LayerDrawable newDrawable;
        if (view instanceof TextureView) {
            return;
        }
        if (view.getBackground() != null) {
            Drawable oldDrawable = view.getBackground();
            if (oldDrawable instanceof LayerDrawable) {
                for (int i = 0; i < ((LayerDrawable)oldDrawable).getNumberOfLayers(); ++i) {
                    if (!(((LayerDrawable)oldDrawable).getDrawable(i) instanceof ViewBorderDrawable)) continue;
                    return;
                }
                newDrawable = new LayerDrawable(new Drawable[]{oldDrawable, new ViewBorderDrawable(view)});
            } else {
                newDrawable = new LayerDrawable(new Drawable[]{oldDrawable, new ViewBorderDrawable(view)});
            }
        } else {
            newDrawable = new LayerDrawable(new Drawable[]{new ViewBorderDrawable(view)});
        }
        try {
            view.setBackground((Drawable)newDrawable);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    private void clearChild(View view) {
        if (view instanceof ViewGroup) {
            this.clearDrawable(view);
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = 0; index < childCount; ++index) {
                    this.clearChild(((ViewGroup)view).getChildAt(index));
                }
            }
        } else {
            this.clearDrawable(view);
        }
    }

    private void clearDrawable(View view) {
        if (view.getBackground() == null) {
            return;
        }
        Drawable oldDrawable = view.getBackground();
        if (!(oldDrawable instanceof LayerDrawable)) {
            return;
        }
        LayerDrawable layerDrawable = (LayerDrawable)oldDrawable;
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        for (int i = 0; i < layerDrawable.getNumberOfLayers(); ++i) {
            if (layerDrawable.getDrawable(i) instanceof ViewBorderDrawable) continue;
            drawables.add(layerDrawable.getDrawable(i));
        }
        LayerDrawable newDrawable = new LayerDrawable(drawables.toArray(new Drawable[drawables.size()]));
        view.setBackground((Drawable)newDrawable);
    }
}

