/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.gpsmock;

import android.content.Context;
import android.os.IBinder;
import android.telephony.gsm.GsmCellLocation;
import com.didichuxing.doraemonkit.kit.gpsmock.BaseServiceHooker;
import com.didichuxing.doraemonkit.kit.gpsmock.GpsMockManager;
import com.didichuxing.doraemonkit.kit.gpsmock.MethodHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TelephonyHooker
extends BaseServiceHooker {
    @Override
    public String serviceName() {
        return "phone";
    }

    @Override
    public String stubName() {
        return "com.android.internal.telephony.ITelephony$Stub";
    }

    @Override
    public Map<String, MethodHandler> registerMethodHandlers() {
        HashMap<String, MethodHandler> methodHandlers = new HashMap<String, MethodHandler>();
        methodHandlers.put("getAllCellInfo", new GetAllCellInfoMethodHandler());
        methodHandlers.put("getCellLocation", new GetCellLocationMethodHandler());
        methodHandlers.put("listen", new ListenMethodHandler());
        return methodHandlers;
    }

    @Override
    public void replaceBinderProxy(Context context, IBinder proxy) {
    }

    static class ListenMethodHandler
    extends MethodHandler {
        ListenMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            return null;
        }
    }

    static class GetCellLocationMethodHandler
    extends MethodHandler {
        GetCellLocationMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            return new GsmCellLocation();
        }
    }

    static class GetAllCellInfoMethodHandler
    extends MethodHandler {
        GetAllCellInfoMethodHandler() {
        }

        @Override
        public Object onInvoke(Object originObject, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (!GpsMockManager.getInstance().isMocking()) {
                return method.invoke(originObject, args);
            }
            return new ArrayList();
        }
    }
}

