/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.fileexplorer;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.util.DoKitImageUtil;
import java.io.File;
import java.lang.ref.WeakReference;

public class ImageDetailFragment
extends BaseFragment {
    private static final String TAG = "ImageDetailFragment";
    private ImageView mImageView;
    private File mFile;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mImageView = (ImageView)this.findViewById(R.id.image);
        Bundle data = this.getArguments();
        if (data != null) {
            this.mFile = (File)data.getSerializable("file_key");
        }
        this.readImage(this.mFile);
    }

    private void readImage(File file) {
        if (file == null) {
            return;
        }
        ImageReadTask task = new ImageReadTask(this);
        task.execute(new File[]{file});
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_image_detail;
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mImageView.setImageBitmap(null);
    }

    private static class ImageReadTask
    extends AsyncTask<File, Void, Bitmap> {
        private WeakReference<ImageDetailFragment> mReference;

        public ImageReadTask(ImageDetailFragment fragment) {
            this.mReference = new WeakReference<ImageDetailFragment>(fragment);
        }

        protected Bitmap doInBackground(File ... files) {
            return DoKitImageUtil.decodeSampledBitmapFromFilePath(files[0].getPath(), 1080, 1920);
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            if (this.mReference.get() != null) {
                ((ImageDetailFragment)((Object)this.mReference.get())).mImageView.setImageBitmap(bitmap);
            }
        }
    }
}

