/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.colorpick;

import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.ColorPickConfig;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerDokitView;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerInfoDokitView;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.DoKitViewLaunchMode;
import com.didichuxing.doraemonkit.util.ToastUtils;

public class ColorPickerSettingFragment
extends BaseFragment {
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.requestCaptureScreen()) {
            ColorPickConfig.setColorPickOpen(true);
        }
    }

    private boolean requestCaptureScreen() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getContext().getSystemService("media_projection");
        if (mediaProjectionManager == null) {
            return false;
        }
        this.startActivityForResult(mediaProjectionManager.createScreenCaptureIntent(), 10001);
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10001 && resultCode == -1) {
            if (!DoKitManager.IS_NORMAL_FLOAT_MODE) {
                this.finish();
            }
            this.showColorPicker(data);
        } else {
            ToastUtils.showShort((CharSequence)"start color pick fail");
            this.finish();
        }
    }

    private void showColorPicker(Intent intent) {
        DoKit.launchFloating(ColorPickerInfoDokitView.class);
        Bundle bundle = new Bundle();
        bundle.putParcelable("data", (Parcelable)intent);
        DoKit.launchFloating(ColorPickerDokitView.class, DoKitViewLaunchMode.SINGLE_INSTANCE, bundle);
    }

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_color_picker_setting;
    }
}

