/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.colorpick;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.config.ColorPickConfig;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickManager;
import com.didichuxing.doraemonkit.kit.colorpick.ColorPickerDokitView;
import com.didichuxing.doraemonkit.kit.core.AbsDokitView;
import com.didichuxing.doraemonkit.kit.core.DokitViewLayoutParams;
import com.didichuxing.doraemonkit.kit.core.TranslucentActivity;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.ColorUtil;
import com.didichuxing.doraemonkit.util.UIUtils;

public class ColorPickerInfoDokitView
extends AbsDokitView {
    private ImageView mColor;
    private TextView mColorHex;
    private ImageView mClose;

    @Override
    public void onCreate(Context context) {
    }

    @Override
    public View onCreateView(Context context, FrameLayout view) {
        return LayoutInflater.from((Context)context).inflate(R.layout.dk_float_color_picker_info, null);
    }

    @Override
    public void initDokitViewLayoutParams(DokitViewLayoutParams params) {
        params.width = this.getScreenShortSideLength();
        params.height = -2;
        params.x = 0;
        params.y = UIUtils.getHeightPixels() - UIUtils.dp2px(95.0f);
    }

    @Override
    public void onViewCreated(FrameLayout view) {
        this.initView();
    }

    private void initView() {
        this.mColor = (ImageView)this.findViewById(R.id.color);
        this.mColorHex = (TextView)this.findViewById(R.id.color_hex);
        this.mClose = (ImageView)this.findViewById(R.id.close);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ColorPickManager.getInstance().setColorPickerDokitView(null);
                ColorPickConfig.setColorPickOpen(false);
                DoKit.removeFloating(ColorPickerDokitView.class);
                DoKit.removeFloating(ColorPickerInfoDokitView.class);
                if (ActivityUtils.getTopActivity() != null && ActivityUtils.getTopActivity() instanceof TranslucentActivity) {
                    ActivityUtils.getTopActivity().finish();
                }
            }
        });
    }

    public void showInfo(@ColorInt int colorInt, int x, int y) {
        this.mColor.setImageDrawable((Drawable)new ColorDrawable(colorInt));
        this.mColorHex.setText((CharSequence)String.format("%s   %d,%d", ColorUtil.parseColorInt(colorInt), x + 16, y + 16));
    }

    @Override
    public void onEnterBackground() {
    }

    @Override
    public void onEnterForeground() {
    }
}

