/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor.core;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Debug;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Printer;
import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.blockmonitor.bean.BlockInfo;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.BlockCanaryUtils;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.MonitorCore;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.OnBlockInfoUpdateListener;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.core.UniversalActivity;
import com.didichuxing.doraemonkit.kit.health.AppHealthInfoUtil;
import com.didichuxing.doraemonkit.kit.health.model.AppHealthInfo;
import com.didichuxing.doraemonkit.kit.timecounter.TimeCounterManager;
import com.didichuxing.doraemonkit.util.ActivityUtils;
import com.didichuxing.doraemonkit.util.DoKitNotificationUtils;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BlockMonitorManager {
    private static final String TAG = "BlockMonitorManager";
    private static final int MAX_SIZE = 50;
    private boolean mIsRunning;
    private MonitorCore mMonitorCore;
    private Context mContext;
    private List<BlockInfo> mBlockInfoList = Collections.synchronizedList(new ArrayList());
    private OnBlockInfoUpdateListener mOnBlockInfoUpdateListener;

    public static BlockMonitorManager getInstance() {
        return Holder.INSTANCE;
    }

    private BlockMonitorManager() {
    }

    public void start() {
        if (this.mIsRunning) {
            LogHelper.i(TAG, "start when manager is running");
            return;
        }
        TimeCounterManager.get().stop();
        this.mContext = DoKit.APPLICATION.getApplicationContext();
        if (this.mMonitorCore == null) {
            this.mMonitorCore = new MonitorCore();
        }
        this.mIsRunning = true;
        Looper.getMainLooper().setMessageLogging((Printer)this.mMonitorCore);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void stop() {
        if (!this.mIsRunning) {
            LogHelper.i(TAG, "stop when manager is not running");
            return;
        }
        Looper.getMainLooper().setMessageLogging(null);
        if (this.mMonitorCore != null) {
            this.mMonitorCore.shutDown();
            this.mMonitorCore = null;
        }
        DoKitNotificationUtils.cancelNotification(this.mContext, 1001);
        this.mIsRunning = false;
        this.mContext = null;
    }

    public void setOnBlockInfoUpdateListener(OnBlockInfoUpdateListener onBlockInfoUpdateListener) {
        this.mOnBlockInfoUpdateListener = onBlockInfoUpdateListener;
    }

    private void addBlockInfoInAppHealth(@NonNull BlockInfo blockInfo) {
        try {
            String activityName = ActivityUtils.getTopActivity().getClass().getCanonicalName();
            AppHealthInfo.DataBean.BlockBean blockBean = new AppHealthInfo.DataBean.BlockBean();
            blockBean.setPage(activityName);
            blockBean.setBlockTime(blockInfo.timeCost);
            blockBean.setDetail(blockInfo.toString());
            AppHealthInfoUtil.getInstance().addBlockInfo(blockBean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void notifyBlockEvent(BlockInfo blockInfo) {
        blockInfo.concernStackString = BlockCanaryUtils.concernStackString(this.mContext, blockInfo);
        blockInfo.time = System.currentTimeMillis();
        if (!TextUtils.isEmpty((CharSequence)blockInfo.concernStackString)) {
            if (DoKitManager.APP_HEALTH_RUNNING && !Debug.isDebuggerConnected()) {
                this.addBlockInfoInAppHealth(blockInfo);
            }
            this.showNotification(blockInfo);
            if (this.mBlockInfoList.size() > 50) {
                this.mBlockInfoList.remove(0);
            }
            this.mBlockInfoList.add(blockInfo);
            if (this.mOnBlockInfoUpdateListener != null) {
                this.mOnBlockInfoUpdateListener.onBlockInfoUpdate(blockInfo);
            }
        }
    }

    private void showNotification(BlockInfo info) {
        String contentTitle = this.mContext.getString(R.string.dk_block_class_has_blocked, new Object[]{info.timeStart});
        String contentText = this.mContext.getString(R.string.dk_block_notification_message);
        Intent intent = new Intent(this.mContext, UniversalActivity.class);
        intent.setFlags(0x14000000);
        intent.putExtra("fragment_index", 8);
        intent.putExtra("KEY_JUMP_TO_LIST", true);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)1, (Intent)intent, (int)0x8000000);
        DoKitNotificationUtils.setInfoNotification(this.mContext, 1001, contentTitle, contentText, contentText, pendingIntent);
    }

    public List<BlockInfo> getBlockInfoList() {
        return this.mBlockInfoList;
    }

    private static class Holder {
        private static BlockMonitorManager INSTANCE = new BlockMonitorManager();

        private Holder() {
        }
    }
}

