/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.blockmonitor;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.blockmonitor.BlockListAdapter;
import com.didichuxing.doraemonkit.kit.blockmonitor.bean.BlockInfo;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.BlockMonitorManager;
import com.didichuxing.doraemonkit.kit.blockmonitor.core.OnBlockInfoUpdateListener;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.util.LogHelper;
import com.didichuxing.doraemonkit.widget.recyclerview.DividerItemDecoration;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BlockListFragment
extends BaseFragment
implements OnBlockInfoUpdateListener {
    private static final String TAG = "BlockMonitorIndexFragment";
    private RecyclerView mBlockList;
    private BlockListAdapter mBlockListAdapter;
    private TextView mLogDetail;
    private TitleBar mTitleBar;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_block_list;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
        this.load();
        BlockMonitorManager.getInstance().setOnBlockInfoUpdateListener(this);
    }

    private void initView() {
        this.mBlockList = (RecyclerView)this.findViewById(R.id.block_list);
        this.mLogDetail = (TextView)this.findViewById(R.id.tx_block_detail);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mBlockList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mBlockListAdapter = new BlockListAdapter(this.getContext());
        this.mBlockList.setAdapter((RecyclerView.Adapter)this.mBlockListAdapter);
        DividerItemDecoration decoration = new DividerItemDecoration(1);
        decoration.setDrawable(this.getResources().getDrawable(R.drawable.dk_divider));
        this.mBlockList.addItemDecoration((RecyclerView.ItemDecoration)decoration);
        this.mBlockListAdapter.setOnItemClickListener(new BlockListAdapter.OnItemClickListener(){

            @Override
            public void onClick(BlockInfo info) {
                LogHelper.i(BlockListFragment.TAG, info.toString());
                BlockListFragment.this.mLogDetail.setText((CharSequence)info.toString());
                BlockListFragment.this.mLogDetail.setVisibility(0);
                BlockListFragment.this.mBlockList.setVisibility(8);
                BlockListFragment.this.mTitleBar.setTitle(BlockListFragment.this.getResources().getString(R.string.dk_kit_block_monitor_detail), false);
            }
        });
        this.mTitleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        this.mTitleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                BlockListFragment.this.getActivity().onBackPressed();
            }

            @Override
            public void onRightClick() {
            }
        });
    }

    @Override
    public boolean onBackPressed() {
        if (this.mLogDetail.getVisibility() == 0) {
            this.mLogDetail.setVisibility(8);
            this.mBlockList.setVisibility(0);
            this.mTitleBar.setTitle(R.string.dk_kit_block_monitor_list);
            return true;
        }
        return super.onBackPressed();
    }

    private void load() {
        ArrayList<BlockInfo> infos = new ArrayList<BlockInfo>(BlockMonitorManager.getInstance().getBlockInfoList());
        Collections.sort(infos, new Comparator<BlockInfo>(){

            @Override
            public int compare(BlockInfo lhs, BlockInfo rhs) {
                return Long.valueOf(rhs.time).compareTo(lhs.time);
            }
        });
        this.mBlockListAdapter.setData(infos);
    }

    public void onDestroyView() {
        super.onDestroyView();
        BlockMonitorManager.getInstance().setOnBlockInfoUpdateListener(null);
    }

    @Override
    public void onBlockInfoUpdate(BlockInfo blockInfo) {
        this.mBlockListAdapter.append(blockInfo, 0);
    }
}

