/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.picasso;

import android.graphics.Bitmap;
import android.net.Uri;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.squareup.picasso.Transformation;

public class DokitPicassoTransformation
implements Transformation {
    private static final String TAG = "DokitTransformation";
    private Uri mUri;
    private int mResourceId;

    public DokitPicassoTransformation(Uri uri, int resourceId) {
        this.mUri = uri;
        this.mResourceId = resourceId;
    }

    public Bitmap transform(Bitmap source) {
        try {
            if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                if (this.mUri != null) {
                    double imgSize = ConvertUtils.byte2MemorySize((long)source.getByteCount(), (int)0x100000);
                    LargePictureManager.getInstance().saveImageInfo(this.mUri.toString(), imgSize, source.getWidth(), source.getHeight(), "Picasso");
                } else {
                    double imgSize = ConvertUtils.byte2MemorySize((long)source.getByteCount(), (int)0x100000);
                    LargePictureManager.getInstance().saveImageInfo("" + this.mResourceId, imgSize, source.getWidth(), source.getHeight(), "Picasso");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return source;
    }

    public String key() {
        return "Dokit&Picasso&LargeBitmapTransformation";
    }
}

