/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.aop.bigimg.imageloader;

import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.config.PerformanceSpInfoConfig;
import com.didichuxing.doraemonkit.kit.largepicture.LargePictureManager;
import com.didichuxing.doraemonkit.util.ConvertUtils;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;

public class DokitImageLoadingListener
implements ImageLoadingListener {
    private static final String TAG = "DokitImageLoadingListener";
    @Nullable
    private ImageLoadingListener mOriginalImageLoadingListener;

    public DokitImageLoadingListener(ImageLoadingListener imageLoadingListener) {
        this.mOriginalImageLoadingListener = imageLoadingListener;
    }

    public void onLoadingStarted(String imageUri, View view) {
        if (this.mOriginalImageLoadingListener != null) {
            this.mOriginalImageLoadingListener.onLoadingStarted(imageUri, view);
        }
    }

    public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
        if (this.mOriginalImageLoadingListener != null) {
            this.mOriginalImageLoadingListener.onLoadingFailed(imageUri, view, failReason);
        }
    }

    public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
        try {
            if (PerformanceSpInfoConfig.isLargeImgOpen()) {
                double imgSize = ConvertUtils.byte2MemorySize((long)loadedImage.getByteCount(), (int)0x100000);
                LargePictureManager.getInstance().saveImageInfo(imageUri, imgSize, loadedImage.getWidth(), loadedImage.getHeight(), "ImageLoader");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mOriginalImageLoadingListener != null) {
            this.mOriginalImageLoadingListener.onLoadingComplete(imageUri, view, loadedImage);
        }
    }

    public void onLoadingCancelled(String imageUri, View view) {
        if (this.mOriginalImageLoadingListener != null) {
            this.mOriginalImageLoadingListener.onLoadingCancelled(imageUri, view);
        }
    }
}

