/*
 * Decompiled with CFR 0.152.
 */
package io.github.crow_misia.libyuv;

import io.github.crow_misia.libyuv.Yuv;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0000H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/github/crow_misia/libyuv/Plane;", "", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "rowStride", "", "getRowStride", "()I", "calculateFramePsnr", "", "other", "width", "height", "calculateFrameSsim", "computeSumSquareError", "Ljava/math/BigInteger;", "hammingDistance", "hashDjb2", "", "seed", "setValue", "", "value", "libyuv-android"})
public interface Plane {
    public int getRowStride();

    @NotNull
    public ByteBuffer getBuffer();

    public long hashDjb2();

    public long hashDjb2(long var1);

    @NotNull
    public BigInteger hammingDistance(@NotNull Plane var1);

    @NotNull
    public BigInteger computeSumSquareError(@NotNull Plane var1, int var2, int var3);

    public double calculateFramePsnr(@NotNull Plane var1, int var2, int var3);

    public double calculateFrameSsim(@NotNull Plane var1, int var2, int var3);

    public void setValue(int var1, int var2, int var3);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static long hashDjb2(@NotNull Plane $this) {
            return $this.hashDjb2(5381L);
        }

        public static long hashDjb2(@NotNull Plane $this, long seed) {
            return Yuv.INSTANCE.hashDjb2($this.getBuffer(), $this.getBuffer().capacity(), seed);
        }

        @NotNull
        public static BigInteger hammingDistance(@NotNull Plane $this, @NotNull Plane other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new BigInteger(Yuv.INSTANCE.computeHammingDistance($this.getBuffer(), other.getBuffer(), Math.min($this.getBuffer().capacity(), other.getBuffer().capacity())));
        }

        @NotNull
        public static BigInteger computeSumSquareError(@NotNull Plane $this, @NotNull Plane other, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new BigInteger(Yuv.INSTANCE.computeSumSquareErrorPlane($this.getBuffer(), $this.getRowStride(), other.getBuffer(), other.getRowStride(), width, height));
        }

        public static double calculateFramePsnr(@NotNull Plane $this, @NotNull Plane other, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Yuv.INSTANCE.calcFramePsnr($this.getBuffer(), $this.getRowStride(), other.getBuffer(), other.getRowStride(), width, height);
        }

        public static double calculateFrameSsim(@NotNull Plane $this, @NotNull Plane other, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Yuv.INSTANCE.calcFrameSsim($this.getBuffer(), $this.getRowStride(), other.getBuffer(), other.getRowStride(), width, height);
        }

        public static void setValue(@NotNull Plane $this, int width, int height, int value) {
            Yuv.INSTANCE.planerSetPlane($this.getBuffer(), $this.getRowStride(), width, height, value);
        }
    }
}

