/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.utils;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum GitDiffMode {
    COMMIT("commit"),
    BRANCH("branch"),
    BRANCH_TWO_DOT("branchTwoDotted"),
    BRANCH_THREE_DOT("branchThreeDotted");

    private final String commandOption;

    private GitDiffMode(String commandOption) {
        this.commandOption = commandOption;
    }

    public String getCommandOption() {
        return this.commandOption;
    }

    public static GitDiffMode getMode(String commandOption) {
        return Arrays.stream(GitDiffMode.values()).filter(e -> e.getCommandOption().equals(commandOption)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unknown compare mode %s available [%s]", commandOption, GitDiffMode.getAvailableOptions())));
    }

    private static String getAvailableOptions() {
        return Arrays.stream(GitDiffMode.values()).map(GitDiffMode::getCommandOption).sorted().collect(Collectors.joining(", "));
    }
}

