/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.providers;

import io.github.crimix.changedprojectstask.configuration.ChangedProjectsConfiguration;
import io.github.crimix.changedprojectstask.extensions.Extensions;
import io.github.crimix.changedprojectstask.utils.Pair;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.logging.Logger;

public class ProjectDependencyProvider {
    private final Project project;
    private final ChangedProjectsConfiguration extension;
    private final Map<Project, Set<Project>> projectDependentsMap;

    public ProjectDependencyProvider(Project project, ChangedProjectsConfiguration extension) {
        this.project = project;
        this.extension = extension;
        this.projectDependentsMap = this.initProjectDependents();
    }

    private Map<Project, Set<Project>> initProjectDependents() {
        return this.project.getSubprojects().stream().map(this::getProjectDependencies).flatMap(Collection::stream).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }

    private Set<Pair<Project, Project>> getProjectDependencies(Project subproject) {
        return subproject.getConfigurations().stream().map(Configuration::getDependencies).map(dependencySet -> dependencySet.withType(ProjectDependency.class)).flatMap(Collection::stream).map(ProjectDependency::getDependencyProject).map(p -> new Pair<Project, Project>((Project)p, subproject)).collect(Collectors.toSet());
    }

    public Project getChangedProject(File file) {
        Path filePath = Extensions.getCanonicalFilePath(file);
        if (!filePath.startsWith(Extensions.getCanonicalProjectPath(this.project.getRootProject()))) {
            return null;
        }
        Project result = this.project.getAllprojects().stream().filter(this.doesFilePathStartWithProjectDirPath(file)).max(Comparator.comparingInt(Extensions::getCanonicalProjectPathStringLength)).orElseGet(this.getFallback(file));
        if (Extensions.shouldLog(this.extension)) {
            this.project.getLogger().lifecycle("File {} belongs to {}", new Object[]{file, result});
        }
        return result;
    }

    private Predicate<Project> doesFilePathStartWithProjectDirPath(File file) {
        return subproject -> {
            Path subprojectPath = Extensions.getCanonicalProjectPath(subproject);
            Path filePath = Extensions.getCanonicalFilePath(file);
            return filePath.startsWith(subprojectPath);
        };
    }

    private Supplier<Project> getFallback(File file) {
        return () -> {
            if (Extensions.shouldLog(this.extension)) {
                this.project.getLogger().lifecycle("USING FALLBACK for file {}", new Object[]{file});
            }
            return this.project.getRootProject();
        };
    }

    public Set<Project> getAffectedDependentProjects(Set<Project> directlyChangedProjects) {
        HashSet alreadyVisitedProjects = new HashSet();
        return directlyChangedProjects.stream().map(p -> this.getDependentProjects((Project)p, alreadyVisitedProjects)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<Project> getDependentProjects(Project project, Set<Project> alreadyVisitedProjects) {
        if (alreadyVisitedProjects.contains(project)) {
            return Collections.emptySet();
        }
        HashSet<Project> result = new HashSet<Project>(this.projectDependentsMap.getOrDefault(project, Collections.emptySet()));
        alreadyVisitedProjects.add(project);
        Set dependents = result.stream().map(p -> this.getDependentProjects((Project)p, alreadyVisitedProjects)).flatMap(Collection::stream).collect(Collectors.toSet());
        result.addAll(dependents);
        return result;
    }

    public void printDebug(Logger logger) {
        if (Extensions.shouldLog(this.extension)) {
            logger.lifecycle("Printing project dependents map");
            this.projectDependentsMap.forEach((key, value) -> logger.lifecycle("Project: {} is a direct dependent for the following {}", new Object[]{key, value}));
            logger.lifecycle("");
        }
    }
}

