/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.providers;

import io.github.crimix.changedprojectstask.configuration.ChangedProjectsConfiguration;
import io.github.crimix.changedprojectstask.extensions.Extensions;
import io.github.crimix.changedprojectstask.providers.GitCommandProvider;
import io.github.crimix.changedprojectstask.utils.CollectingOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class ChangedFilesProvider {
    private final Project project;
    private final ChangedProjectsConfiguration extension;
    private final GitCommandProvider gitCommandProvider;
    private final List<File> filteredChanges;
    private final boolean affectsAllProjects;

    public ChangedFilesProvider(Project project, ChangedProjectsConfiguration extension) {
        this.project = project;
        this.extension = extension;
        this.gitCommandProvider = new GitCommandProvider(project);
        List<String> gitFilteredChanges = this.initFilteredChanges();
        this.filteredChanges = this.initFilteredChangedFiles(gitFilteredChanges);
        this.affectsAllProjects = this.initAffectsAllProjects(gitFilteredChanges);
    }

    private List<String> initFilteredChanges() {
        File gitRoot = Extensions.getGitRootDir(this.project);
        if (gitRoot == null) {
            throw new IllegalStateException("The project does not have a git root");
        }
        CollectingOutputStream stdout = new CollectingOutputStream();
        CollectingOutputStream stderr = new CollectingOutputStream();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr)));
        exec.setWorkingDirectory(gitRoot);
        exec.execute(CommandLine.parse((String)this.gitCommandProvider.getGitDiffCommand()));
        if (stderr.isNotEmpty()) {
            if (this.containsErrors(stderr)) {
                throw new IllegalStateException(String.format("Failed to run git diff because of \n%s", new Object[]{stderr}));
            }
            if (this.project.getLogger().isWarnEnabled()) {
                this.project.getLogger().warn(stderr.toString());
            }
        }
        if (stdout.isEmpty()) {
            throw new IllegalStateException("Git diff returned no results this must be a mistake");
        }
        Predicate<String> filter = ((Set)this.extension.getIgnoredRegex().getOrElse(Collections.emptySet())).stream().map(Pattern::asMatchPredicate).reduce(Predicate::or).orElse(x -> false);
        return stdout.getLines().stream().filter(Predicate.not(filter)).collect(Collectors.toList());
    }

    private boolean containsErrors(CollectingOutputStream stderr) {
        return stderr.getLines().stream().anyMatch(line -> line.startsWith("error:"));
    }

    private boolean initAffectsAllProjects(List<String> gitFilteredChanges) {
        Predicate<String> filter = ((Set)this.extension.getAffectsAllRegex().getOrElse(Collections.emptySet())).stream().map(Pattern::asMatchPredicate).reduce(Predicate::or).orElse(x -> false);
        return gitFilteredChanges.stream().anyMatch(filter);
    }

    private List<File> initFilteredChangedFiles(List<String> gitFilteredChanges) {
        File gitRoot = Extensions.getGitRootDir(this.project);
        if (gitRoot == null) {
            throw new IllegalStateException("The project does not have a git root");
        }
        return gitFilteredChanges.stream().map(s -> new File(gitRoot, (String)s)).collect(Collectors.toList());
    }

    public List<File> getChangedFiles() {
        return this.filteredChanges;
    }

    public boolean isAllProjectsAffected() {
        return this.affectsAllProjects;
    }

    public void printDebug(Logger logger) {
        if (Extensions.shouldLog(this.extension)) {
            logger.lifecycle("Git diff command uses {}", new Object[]{this.gitCommandProvider.getGitDiffCommand()});
            logger.lifecycle("All projects affected? {}", new Object[]{this.isAllProjectsAffected()});
            logger.lifecycle("Changed files:");
            this.getChangedFiles().forEach(file -> logger.lifecycle(file.toString()));
            logger.lifecycle("");
        }
    }
}

