/*
 * Decompiled with CFR 0.152.
 */
package io.github.crimix.changedprojectstask.extensions;

import io.github.crimix.changedprojectstask.configuration.ChangedProjectsChoice;
import io.github.crimix.changedprojectstask.configuration.ChangedProjectsConfiguration;
import io.github.crimix.changedprojectstask.utils.GitDiffMode;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class Extensions {
    public static boolean isRootProject(Project project) {
        return project.equals(project.getRootProject());
    }

    public static String getProjectDirName(Project project) {
        return project.getProjectDir().getName();
    }

    public static boolean hasBeenEnabled(Project project) {
        return project.getRootProject().hasProperty("changedProjectsTask.run") || project.getRootProject().hasProperty("changedProjectsTask.runCommandLine");
    }

    public static boolean hasBothRunCommands(Project project) {
        return project.getRootProject().hasProperty("changedProjectsTask.run") && project.getRootProject().hasProperty("changedProjectsTask.runCommandLine");
    }

    public static String getTaskToRun(Project project, ChangedProjectsConfiguration configuration) {
        return Optional.of(project).map(Project::getRootProject).map(p -> p.findProperty("changedProjectsTask.taskToRun")).map(String.class::cast).orElseGet(() -> (String)configuration.getTaskToRun().getOrNull());
    }

    public static Optional<String> getCommitId(Project project) {
        return Optional.of(project).map(Project::getRootProject).map(p -> p.findProperty("changedProjectsTask.commit")).map(String.class::cast);
    }

    public static boolean shouldUseCommandLine(Project project) {
        return project.getRootProject().hasProperty("changedProjectsTask.runCommandLine");
    }

    public static String getCommandLineArgs(Project project) {
        return Optional.of(project).map(Project::getRootProject).map(p -> p.findProperty("changedProjectsTask.commandLineArgs")).map(String.class::cast).orElse("");
    }

    public static Optional<String> getPreviousCommitId(Project project) {
        return Optional.of(project).map(Project::getRootProject).map(p -> p.findProperty("changedProjectsTask.prevCommit")).map(String.class::cast);
    }

    public static GitDiffMode getCommitCompareMode(Project project) {
        return Optional.of(project).map(Project::getRootProject).map(p -> p.findProperty("changedProjectsTask.compareMode")).map(String.class::cast).map(GitDiffMode::getMode).orElse(GitDiffMode.COMMIT);
    }

    public static File getGitRootDir(Project project) {
        for (File currentDir = project.getRootProject().getProjectDir(); currentDir != null && !currentDir.getPath().equals("/"); currentDir = currentDir.getParentFile()) {
            if (!new File(String.format("%s/.git", currentDir.getPath())).exists()) continue;
            return currentDir;
        }
        return null;
    }

    public static Path getCanonicalProjectPath(Project project) {
        return project.getProjectDir().getCanonicalFile().toPath();
    }

    public static int getCanonicalProjectPathStringLength(Project project) {
        return project.getProjectDir().getCanonicalFile().toPath().toString().length();
    }

    public static Path getCanonicalFilePath(File file) {
        return file.getCanonicalFile().toPath();
    }

    public static void validate(ChangedProjectsConfiguration configuration, Project root) {
        String taskToRun = Extensions.getTaskToRun(root, configuration);
        if (taskToRun == null || taskToRun.isEmpty()) {
            throw new IllegalArgumentException("changedProjectsTask: taskToRun is required");
        }
        if (taskToRun.startsWith(":")) {
            throw new IllegalArgumentException("changedProjectsTask: taskToRun should not start with :");
        }
        Set projectsAlwaysRun = (Set)configuration.getAlwaysRunProject().getOrElse(Collections.emptySet());
        for (String project : projectsAlwaysRun) {
            if (project.startsWith(":")) continue;
            throw new IllegalArgumentException(String.format("changedProjectsTask: alwaysRunProject %s must start with :", project));
        }
        configuration.getAffectsAllRegex().getOrElse(Collections.emptySet());
        configuration.getIgnoredRegex().getOrElse(Collections.emptySet());
        String mode = (String)configuration.getChangedProjectsMode().getOrElse((Object)ChangedProjectsChoice.INCLUDE_DEPENDENTS.name());
        try {
            ChangedProjectsChoice.valueOf(mode);
        }
        catch (IllegalArgumentException ignored) {
            throw new IllegalArgumentException(String.format("changedProjectsTask: ChangedProjectsMode must be either %s or %s ", ChangedProjectsChoice.ONLY_DIRECTLY.name(), ChangedProjectsChoice.INCLUDE_DEPENDENTS.name()));
        }
    }

    public static ChangedProjectsChoice getPluginMode(ChangedProjectsConfiguration configuration) {
        return ChangedProjectsChoice.valueOf((String)configuration.getChangedProjectsMode().getOrElse((Object)ChangedProjectsChoice.INCLUDE_DEPENDENTS.name()));
    }

    public static void print(ChangedProjectsConfiguration configuration, Project project, Logger logger) {
        if (Extensions.shouldLog(configuration)) {
            logger.lifecycle("Printing configuration");
            logger.lifecycle("Task to run {}", new Object[]{Extensions.getTaskToRun(project, configuration)});
            logger.lifecycle("Always run project {}", new Object[]{configuration.getAlwaysRunProject().getOrElse(Collections.emptySet())});
            logger.lifecycle("Never run project {}", new Object[]{configuration.getNeverRunProject().getOrElse(Collections.emptySet())});
            logger.lifecycle("Affects all regex {}", new Object[]{configuration.getAffectsAllRegex().getOrElse(Collections.emptySet())});
            logger.lifecycle("Ignored regex {}", new Object[]{configuration.getIgnoredRegex().getOrElse(Collections.emptySet())});
            logger.lifecycle("Mode {}", new Object[]{Extensions.getPluginMode(configuration)});
            logger.lifecycle("");
        }
    }

    public static boolean shouldLog(ChangedProjectsConfiguration configuration) {
        return (Boolean)configuration.getDebugLogging().getOrElse((Object)false);
    }
}

