/*
 * Decompiled with CFR 0.152.
 */
package io.github.cpetot.archunit;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import io.github.cpetot.archunit.StandardCodingRules;
import java.util.stream.Stream;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

public final class SpringCodingRules {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> BE_ACCESSED_BY_TRANSACTIONAL_CLASSES_OR_METHODS = SpringCodingRules.beAccessedByTransactionalClassesOrMethods();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule REPOSITORIES_ARE_ACCESSED_ONLY_BY_TRANSACTIONAL_METHODS_OR_CLASSES = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAnnotatedWith(Repository.class)).should(BE_ACCESSED_BY_TRANSACTIONAL_CLASSES_OR_METHODS);
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule REPOSITORIES_ARE_ACCESSED_ONLY_BY_SERVICE_CLASSES = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAnnotatedWith(Repository.class)).should(StandardCodingRules.beAccessedOnlyByClassesMetaAnnotatedBy(Service.class));
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule REPOSITORIES_ARE_ACCESSED_ONLY_BY_SERVICE_OR_CONTROLLER_CLASSES = ((GivenClassesConjunction)ArchRuleDefinition.classes().that().areAnnotatedWith(Repository.class)).should(StandardCodingRules.beAccessedOnlyByClassesMetaAnnotatedByAny(Service.class, Controller.class));

    private SpringCodingRules() {
    }

    private static ArchCondition<JavaClass> beAccessedByTransactionalClassesOrMethods() {
        return new ArchCondition<JavaClass>("be accessed by @Transactional classes or methods", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                Stream.concat(javaClass.getMethodCallsFromSelf().stream(), javaClass.getMethodCallsToSelf().stream()).map(methodCall -> {
                    JavaClass originClass = methodCall.getOriginOwner();
                    JavaCodeUnit originMethod = methodCall.getOrigin();
                    if (originClass.equals(javaClass)) {
                        return SimpleConditionEvent.satisfied((Object)methodCall, (String)String.format("Method %s is in the same class", originMethod.getFullName()));
                    }
                    if (originMethod.isAnnotatedWith(Transactional.class)) {
                        return SimpleConditionEvent.satisfied((Object)methodCall, (String)String.format("Method %s is @Transactional", originMethod.getFullName()));
                    }
                    if (originClass.isAnnotatedWith(Transactional.class)) {
                        return SimpleConditionEvent.satisfied((Object)methodCall, (String)String.format("Class %s is @Transactional", originClass.getFullName()));
                    }
                    return SimpleConditionEvent.violated((Object)methodCall, (String)String.format("Neither Class %s or Method %s are annotated by @Transactional", originClass.getFullName(), originMethod.getFullName()));
                }).forEach(arg_0 -> ((ConditionEvents)events).add(arg_0));
            }
        };
    }
}

