/*
 * Decompiled with CFR 0.152.
 */
package io.github.cpetot.archunit;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StandardCodingRules {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> USE_JUNIT_4 = StandardCodingRules.useJunit4();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_USE_JUNIT_4 = ArchRuleDefinition.noClasses().should(USE_JUNIT_4).because("Use JUnit 5 instead");
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> USE_JAVA_UTIL_DATE = StandardCodingRules.useJavaUtilDate();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchRule NO_CLASSES_SHOULD_USE_JAVA_UTIL_DATE = ArchRuleDefinition.noClasses().should(USE_JAVA_UTIL_DATE).because("Use dates API in java.time instead");
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaClass> HAS_A_PUBLIC_EMPTY_CONSTRUCTOR = StandardCodingRules.hasAPublicEmptyConstructor();
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final ArchCondition<JavaMethod> BE_A_VOID_WITHOUT_PARAMETER = StandardCodingRules.beAVoidWithoutParameter();

    private StandardCodingRules() {
    }

    private static ArchCondition<JavaClass> useJunit4() {
        return ArchConditions.dependOnClassesThat((DescribedPredicate)JavaClass.Predicates.resideInAPackage((String)"org.junit")).as("use JUnit 4", new Object[0]);
    }

    private static ArchCondition<JavaClass> useJavaUtilDate() {
        return ArchConditions.dependOnClassesThat((DescribedPredicate)JavaClass.Predicates.type(Date.class)).as("use java.util.Date", new Object[0]);
    }

    private static ArchCondition<JavaClass> hasAPublicEmptyConstructor() {
        return new ArchCondition<JavaClass>("have a public empty constructor", new Object[0]){

            public void check(JavaClass javaClass, ConditionEvents events) {
                boolean hasPublicEmptyConstructor = javaClass.tryGetConstructor().filter(constructor -> constructor.getModifiers().contains(JavaModifier.PUBLIC)).isPresent();
                if (!hasPublicEmptyConstructor) {
                    events.add(SimpleConditionEvent.violated((Object)javaClass, (String)String.format("Class %s has no public empty constructor", javaClass.getFullName())));
                }
            }
        };
    }

    private static ArchCondition<JavaMethod> beAVoidWithoutParameter() {
        return new ArchCondition<JavaMethod>("be a void without any parameter", new Object[0]){

            public void check(JavaMethod method, ConditionEvents events) {
                if (!"void".equals(method.getReturnType().getName())) {
                    events.add(SimpleConditionEvent.violated((Object)method, (String)String.format("Method %s is not a void but returns a %s", method.getFullName(), method.getReturnType().getName())));
                }
                if (!method.getParameters().isEmpty()) {
                    events.add(SimpleConditionEvent.violated((Object)method, (String)String.format("Method %s should be without any parameter but has %d parameter(s)", method.getFullName(), method.getParameters().size())));
                }
            }
        };
    }

    public static DescribedPredicate<JavaCodeUnit> areAnnotatedByAny(final Class<? extends Annotation> ... annotationClasses) {
        String annotationsDescription = Stream.of(annotationClasses).map(Class::getSimpleName).collect(Collectors.joining(" or "));
        return new DescribedPredicate<JavaCodeUnit>("methods that are annotated with " + annotationsDescription, new Object[0]){

            public boolean test(JavaCodeUnit codeUnit) {
                return Stream.of(annotationClasses).anyMatch(arg_0 -> ((JavaCodeUnit)codeUnit).isMetaAnnotatedWith(arg_0));
            }
        };
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAccessedOnlyByClassesMetaAnnotatedBy(final Class<? extends Annotation> annotationClass) {
        return new ArchCondition<JavaClass>("be called by @%s classes", new Object[]{annotationClass.getSimpleName()}){

            public void check(JavaClass javaClass, ConditionEvents events) {
                javaClass.getDirectDependenciesToSelf().stream().map(Dependency::getOriginClass).distinct().filter(originClass -> !originClass.isMetaAnnotatedWith(annotationClass)).map(originClass -> SimpleConditionEvent.violated((Object)originClass, (String)String.format("Class %s is not annotated by @%s", originClass.getFullName(), annotationClass.getSimpleName()))).forEach(arg_0 -> ((ConditionEvents)events).add(arg_0));
            }
        };
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static ArchCondition<JavaClass> beAccessedOnlyByClassesMetaAnnotatedByAny(final Class<? extends Annotation> ... annotationsClasses) {
        final String annotationsDescription = Arrays.stream(annotationsClasses).map(annotationClass -> "@" + annotationClass.getSimpleName()).collect(Collectors.joining(" or "));
        return new ArchCondition<JavaClass>("be called by %s classes", new Object[]{annotationsDescription}){

            public void check(JavaClass javaClass, ConditionEvents events) {
                javaClass.getDirectDependenciesToSelf().stream().map(Dependency::getOriginClass).distinct().filter(originClass -> Arrays.stream(annotationsClasses).noneMatch(arg_0 -> ((JavaClass)originClass).isMetaAnnotatedWith(arg_0))).map(originClass -> SimpleConditionEvent.violated((Object)originClass, (String)String.format("Class %s is annotated neither by %s", originClass.getFullName(), annotationsDescription))).forEach(arg_0 -> ((ConditionEvents)events).add(arg_0));
            }
        };
    }
}

