/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.utilities;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.Keep;
import com.nareshchocha.filepickerlibrary.utilities.extentions.FilePathExtentionsKt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\"\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\u0017"}, d2={"Lcom/nareshchocha/filepickerlibrary/utilities/FileUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getExternalDocumentPath", "getFilePath", "getRealPath", "fileUri", "pathFromURI", "copyFileToInternalStorage", "newDirName", "getDownloadsDocumentPath", "getDriveFilePath", "getMediaDocumentPath", "filepickerlibrary_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/nareshchocha/filepickerlibrary/utilities/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,316:1\n1#2:317\n731#3,9:318\n731#3,9:329\n37#4,2:327\n37#4,2:338\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/nareshchocha/filepickerlibrary/utilities/FileUtils\n*L\n180#1:318,9\n243#1:329,9\n180#1:327,2\n243#1:338,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @Keep
    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        return this.pathFromURI(context, fileUri);
    }

    @Keep
    private final String pathFromURI(Context context, Uri uri) {
        String string2;
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FilePathExtentionsKt.isExternalStorageDocument(uri)) {
                string2 = this.getExternalDocumentPath(uri);
            } else if (FilePathExtentionsKt.isDownloadsDocument(uri)) {
                string2 = this.getDownloadsDocumentPath(context, uri);
                if (string2 == null) {
                    string2 = FileUtils.copyFileToInternalStorage$default(this, context, uri, null, 2, null);
                }
            } else if (FilePathExtentionsKt.isMediaDocument(uri)) {
                string2 = this.getMediaDocumentPath(context, uri);
                if (string2 == null) {
                    string2 = FileUtils.copyFileToInternalStorage$default(this, context, uri, null, 2, null);
                }
            } else {
                string2 = FileUtils.copyFileToInternalStorage$default(this, context, uri, null, 2, null);
            }
        } else if (FilePathExtentionsKt.isGoogleDriveUri(uri)) {
            string2 = this.getDriveFilePath(context, uri);
        } else if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
            if (FilePathExtentionsKt.isGooglePhotosUri(uri)) {
                string2 = uri.getLastPathSegment();
            } else {
                if (FilePathExtentionsKt.isGoogleDriveUri(uri)) {
                    return this.getDriveFilePath(context, uri);
                }
                string2 = this.getDataColumn(context, uri, null, null);
                if (string2 == null) {
                    string2 = FileUtils.copyFileToInternalStorage$default(this, context, uri, null, 2, null);
                }
            }
        } else {
            string2 = StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true) ? uri.getPath() : FileUtils.copyFileToInternalStorage$default(this, context, uri, null, 2, null);
        }
        return string2;
    }

    private final String copyFileToInternalStorage(Context $this$copyFileToInternalStorage, Uri uri, String newDirName) {
        File file;
        Cursor returnCursor;
        if (uri == null) {
            return null;
        }
        String[] stringArray = new String[]{"_display_name", "_size"};
        Cursor cursor = returnCursor = $this$copyFileToInternalStorage.getContentResolver().query(uri, stringArray, null, null, null);
        if (cursor == null) {
            return null;
        }
        int nameIndex = cursor.getColumnIndex("_display_name");
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        if (!Intrinsics.areEqual((Object)newDirName, (Object)"")) {
            File dir = new File($this$copyFileToInternalStorage.getCacheDir(), newDirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            file = new File($this$copyFileToInternalStorage.getCacheDir(), newDirName + "/" + name);
        } else {
            file = new File($this$copyFileToInternalStorage.getCacheDir(), "/" + name);
        }
        File output = file;
        try {
            InputStream inputStream = $this$copyFileToInternalStorage.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(output);
            Integer read = null;
            read = 0;
            int bufferSize = 1024;
            byte[] buffers = new byte[bufferSize];
            while (true) {
                Integer n;
                InputStream inputStream2 = inputStream;
                Integer it = n = inputStream2 != null ? Integer.valueOf(inputStream2.read(buffers)) : null;
                boolean bl = false;
                read = it;
                Integer n2 = n;
                int n3 = -1;
                if (n2 != null && n2 == n3) break;
                Integer n4 = read;
                if (n4 == null) continue;
                int it2 = ((Number)n4).intValue();
                boolean bl2 = false;
                outputStream.write(buffers, 0, it2);
            }
            InputStream inputStream3 = inputStream;
            if (inputStream3 != null) {
                inputStream3.close();
            }
            outputStream.close();
        }
        catch (Exception e) {
            output.delete();
            Timber.Tree tree = Timber.Forest.tag("Exception");
            String string2 = e.getMessage();
            Intrinsics.checkNotNull((Object)string2);
            tree.e(string2, new Object[0]);
            return null;
        }
        return output.getPath();
    }

    static /* synthetic */ String copyFileToInternalStorage$default(FileUtils fileUtils, Context context, Uri uri, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "copyFileToInternalStorage";
        }
        return fileUtils.copyFileToInternalStorage(context, uri, string2);
    }

    private final String getDriveFilePath(Context $this$getDriveFilePath, Uri uri) {
        Cursor returnCursor;
        Cursor cursor = returnCursor = $this$getDriveFilePath.getContentResolver().query(uri, null, null, null, null);
        if (cursor == null) {
            return null;
        }
        int nameIndex = cursor.getColumnIndex("_display_name");
        returnCursor.moveToFirst();
        String name = returnCursor.getString(nameIndex);
        File file = new File($this$getDriveFilePath.getCacheDir(), name);
        try {
            InputStream inputStream = $this$getDriveFilePath.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            Integer read = null;
            read = 0;
            int maxBufferSize = 0x100000;
            InputStream inputStream2 = inputStream;
            int bytesAvailable = inputStream2 != null ? inputStream2.available() : 0;
            int bufferSize = RangesKt.coerceAtMost((int)bytesAvailable, (int)maxBufferSize);
            byte[] buffers = new byte[bufferSize];
            while (true) {
                Integer n;
                InputStream inputStream3 = inputStream;
                Integer it = n = inputStream3 != null ? Integer.valueOf(inputStream3.read(buffers)) : null;
                boolean bl = false;
                read = it;
                Integer n2 = n;
                int n3 = -1;
                if (n2 != null && n2 == n3) break;
                Integer n4 = read;
                if (n4 == null) continue;
                int it2 = ((Number)n4).intValue();
                boolean bl2 = false;
                outputStream.write(buffers, 0, it2);
            }
            InputStream inputStream4 = inputStream;
            if (inputStream4 != null) {
                inputStream4.close();
            }
            outputStream.close();
        }
        catch (Exception e) {
            Timber.Forest.tag("Exception").e(e.getMessage(), new Object[0]);
            return null;
        }
        return file.getPath();
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    private final String getMediaDocumentPath(Context $this$getMediaDocumentPath, Uri uri) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNull((Object)docId);
        Object object = docId;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        String thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        String type = split[0];
        Uri contentUri = null;
        switch (type) {
            case "image": {
                contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                break;
            }
            case "video": {
                contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                break;
            }
            case "audio": {
                contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                break;
            }
            default: {
                contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            }
        }
        String selection = "_id=?";
        String[] stringArray = new String[]{split[1]};
        String[] selectionArgs = stringArray;
        return this.getDataColumn($this$getMediaDocumentPath, contentUri, selection, selectionArgs);
    }

    @Keep
    private final String getDownloadsDocumentPath(Context $this$getDownloadsDocumentPath, Uri uri) {
        Regex regex;
        String id2;
        String fileName = this.getFilePath($this$getDownloadsDocumentPath, uri);
        if (fileName != null) {
            return Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
        }
        CharSequence charSequence = id2 = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNull((Object)charSequence);
        if (StringsKt.startsWith$default((String)charSequence, (String)"raw:", (boolean)false, (int)2, null)) {
            charSequence = id2;
            Intrinsics.checkNotNull((Object)charSequence);
            charSequence = charSequence;
            regex = new Regex("raw:");
            String string2 = "";
            id2 = regex.replaceFirst(charSequence, string2);
            File file = new File(id2);
            if (file.exists()) {
                return id2;
            }
        }
        regex = new Regex[]{"content://downloads/public_downloads", "content://downloads/my_downloads"};
        int n = 0;
        Regex contentUriPrefixesToTry = regex;
        int n2 = ((Regex)contentUriPrefixesToTry).length;
        if (n < n2) {
            String string3;
            Regex contentUriPrefix = contentUriPrefixesToTry[n];
            try {
                Uri uri2 = Uri.parse((String)contentUriPrefix);
                Long l = Long.valueOf(id2);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
                Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)((Number)l).longValue());
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"withAppendedId(...)");
                Uri contentUri = uri3;
                string3 = this.getDataColumn($this$getDownloadsDocumentPath, contentUri, null, null);
            }
            catch (NumberFormatException e) {
                String string4 = uri.getPath();
                Intrinsics.checkNotNull((Object)string4);
                string3 = StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)string4, (String)"^/document/raw:", (String)"", (boolean)false, (int)4, null), (String)"^raw:", (String)"", (boolean)false, (int)4, null);
            }
            return string3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    private final String getExternalDocumentPath(Uri uri) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNull((Object)docId);
        Object object = docId;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        String type = split[0];
        return StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + "/" + split[1] : Environment.getExternalStorageDirectory().toString() + "/") : "storage/" + StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String column = "_data";
            Object[] objectArray = new String[]{column};
            String[] projection = objectArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                objectArray = new Object[]{cursor};
                Timber.Forest.tag("Checked:").d("cursor:: %s", objectArray);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String[] stringArray = new String[]{"_display_name"};
            String[] projection = stringArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }
}

