/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.ui.activitys;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Keep;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.nareshchocha.filepickerlibrary.R;
import com.nareshchocha.filepickerlibrary.models.ImageCaptureConfig;
import com.nareshchocha.filepickerlibrary.permission.PermissionUtils;
import com.nareshchocha.filepickerlibrary.picker.PickerUtils;
import com.nareshchocha.filepickerlibrary.utilities.appConst.Const;
import com.nareshchocha.filepickerlibrary.utilities.extentions.ExtentionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\b0\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/ImageCaptureActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "checkPermission", "Landroidx/activity/result/ActivityResultLauncher;", "", "", "imageCapture", "Landroid/content/Intent;", "imageFile", "Ljava/io/File;", "imageFileUri", "Landroid/net/Uri;", "mImageCaptureConfig", "Lcom/nareshchocha/filepickerlibrary/models/ImageCaptureConfig;", "getMImageCaptureConfig", "()Lcom/nareshchocha/filepickerlibrary/models/ImageCaptureConfig;", "mImageCaptureConfig$delegate", "Lkotlin/Lazy;", "settingCameraResultLauncher", "kotlin.jvm.PlatformType", "getPermission", "", "getPermissionsListString", "launchCamera", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "showAskDialog", "showGotoSettingDialog", "Companion", "filepickerlibrary_release"})
@SourceDebugExtension(value={"SMAP\nImageCaptureActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageCaptureActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/ImageCaptureActivity\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n37#2,2:215\n1#3:217\n1549#4:218\n1620#4,3:219\n1726#4,3:222\n*S KotlinDebug\n*F\n+ 1 ImageCaptureActivity.kt\ncom/nareshchocha/filepickerlibrary/ui/activitys/ImageCaptureActivity\n*L\n75#1:215,2\n141#1:218\n141#1:219,3\n167#1:222,3\n*E\n"})
public final class ImageCaptureActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Uri imageFileUri;
    @Nullable
    private File imageFile;
    @NotNull
    private final Lazy mImageCaptureConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ImageCaptureConfig>(this){
        final /* synthetic */ ImageCaptureActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final ImageCaptureConfig invoke() {
            return Build.VERSION.SDK_INT >= 33 ? (ImageCaptureConfig)this.this$0.getIntent().getParcelableExtra("IMAGE_CAPTURE", ImageCaptureConfig.class) : (ImageCaptureConfig)this.this$0.getIntent().getParcelableExtra("IMAGE_CAPTURE");
        }
    }));
    @NotNull
    private final ActivityResultLauncher<String[]> checkPermission = PermissionUtils.INSTANCE.checkPermission(this, (ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), (Function1)new Function1<Map<String, Boolean>, Unit>(this){
        final /* synthetic */ ImageCaptureActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke(@NotNull Map<String, Boolean> input) {
            boolean isShowRationale;
            boolean allGranted;
            block11: {
                boolean bl;
                void $this$any$iv;
                boolean bl2;
                Object object;
                block10: {
                    void $this$all$iv;
                    Intrinsics.checkNotNullParameter(input, (String)"input");
                    Map<String, Boolean> map = input;
                    object = this.this$0;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl2 = true;
                    } else {
                        Iterator<Map.Entry<K, V>> iterator = $this$all$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> permission = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (ContextCompat.checkSelfPermission((Context)((Context)object), (String)((String)permission.getKey())) == 0) continue;
                            bl2 = false;
                            break block10;
                        }
                        bl2 = true;
                    }
                }
                allGranted = bl2;
                object = input;
                ImageCaptureActivity imageCaptureActivity = this.this$0;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<K, V>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> permission = element$iv = iterator.next();
                        boolean bl4 = false;
                        if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)imageCaptureActivity), (String)((String)permission.getKey()))) continue;
                        bl = true;
                        break block11;
                    }
                    bl = isShowRationale = false;
                }
            }
            if (allGranted) {
                ImageCaptureActivity.access$launchCamera(this.this$0);
            } else if (isShowRationale) {
                ImageCaptureActivity.access$showAskDialog(this.this$0);
            } else {
                ImageCaptureActivity.access$showGotoSettingDialog(this.this$0);
            }
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> imageCapture = PickerUtils.INSTANCE.selectFile(this, (ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (Function1)new Function1<ActivityResult, Unit>(this){
        final /* synthetic */ ImageCaptureActivity this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        public final void invoke(@NotNull ActivityResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            if (result.getResultCode() == -1) {
                Uri uri = ImageCaptureActivity.access$getImageFileUri$p(this.this$0);
                Timber.Forest.tag("FILE_RESULT ::").v("File Uri ::: " + (uri != null ? uri.toString() : null), new Object[0]);
                File file = ImageCaptureActivity.access$getImageFile$p(this.this$0);
                Timber.Forest.tag("FILE_RESULT ::").v("filePath ::: " + (file != null ? file.getAbsoluteFile() : null), new Object[0]);
                File file2 = ImageCaptureActivity.access$getImageFile$p(this.this$0);
                Timber.Forest.tag("FILE_RESULT ::").v("file read:: " + (file2 != null ? Boolean.valueOf(file2.canRead()) : null), new Object[0]);
                File file3 = ImageCaptureActivity.access$getImageFile$p(this.this$0);
                ExtentionsKt.setSuccessResult((Activity)this.this$0, ImageCaptureActivity.access$getImageFileUri$p(this.this$0), file3 != null ? file3.getAbsolutePath() : null, true);
            } else {
                Object[] objectArray = new Object[]{"imageCapture"};
                Timber.Forest.tag("FILE_PICKER_ERROR ::").v(this.this$0.getString(R.string.err_capture_error, objectArray), new Object[0]);
                objectArray = new Object[]{"imageCapture"};
                ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_capture_error, objectArray));
            }
        }
    });
    @NotNull
    private final ActivityResultLauncher<Intent> settingCameraResultLauncher;

    public ImageCaptureActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> ImageCaptureActivity.settingCameraResultLauncher$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
        this.settingCameraResultLauncher = activityResultLauncher;
    }

    private final ImageCaptureConfig getMImageCaptureConfig() {
        Lazy lazy = this.mImageCaptureConfig$delegate;
        return (ImageCaptureConfig)lazy.getValue();
    }

    private final void getPermission() {
        Collection $this$toTypedArray$iv = ImageCaptureActivity.Companion.getPermissionsList((Context)this);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.checkPermission.launch((Object)thisCollection$iv.toArray(new String[0]));
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTitle("");
        if (Build.VERSION.SDK_INT >= 23) {
            if (Build.VERSION.SDK_INT <= 29 || !((Collection)ImageCaptureActivity.Companion.getPermissionsList((Context)this)).isEmpty()) {
                this.getPermission();
            } else {
                this.launchCamera();
            }
        } else {
            this.launchCamera();
        }
    }

    private final void launchCamera() {
        block4: {
            Uri uri;
            if (this.getMImageCaptureConfig() != null) {
                ImageCaptureConfig imageCaptureConfig = this.getMImageCaptureConfig();
                Intrinsics.checkNotNull((Object)imageCaptureConfig);
                File file = imageCaptureConfig.getMFolder();
                if (file == null) {
                    file = Const.DefaultPaths.INSTANCE.defaultFolder((Context)this);
                }
                ImageCaptureConfig imageCaptureConfig2 = this.getMImageCaptureConfig();
                Intrinsics.checkNotNull((Object)imageCaptureConfig2);
                String string2 = imageCaptureConfig2.getFileName();
                if (string2 == null) {
                    string2 = Const.DefaultPaths.INSTANCE.defaultImageFile();
                }
                this.imageFile = PickerUtils.INSTANCE.createMediaFileFolder(file, string2);
                Context context = (Context)this;
                File file2 = this.imageFile;
                Intrinsics.checkNotNull((Object)file2);
                uri = PickerUtils.INSTANCE.createFileGetUri(context, file2);
            } else {
                this.imageFile = PickerUtils.INSTANCE.createMediaFileFolder(Const.DefaultPaths.INSTANCE.defaultFolder((Context)this), Const.DefaultPaths.INSTANCE.defaultImageFile());
                Context context = (Context)this;
                File file = this.imageFile;
                Intrinsics.checkNotNull((Object)file);
                uri = PickerUtils.INSTANCE.createFileGetUri(context, file);
            }
            Uri uri2 = this.imageFileUri = uri;
            if (uri2 == null) break block4;
            Uri it = uri2;
            boolean bl = false;
            this.imageCapture.launch((Object)ExtentionsKt.getImageCaptureIntent((Context)this, it));
        }
    }

    private final void showAskDialog() {
        Object object;
        Context context = (Context)this;
        Object object2 = this.getMImageCaptureConfig();
        if (object2 == null || (object2 = ((ImageCaptureConfig)object2).getAskPermissionTitle()) == null) {
            String string2 = this.getString(R.string.err_permission_denied);
            object2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        }
        if ((object = this.getMImageCaptureConfig()) == null || (object = ((ImageCaptureConfig)object).getAskPermissionMessage()) == null) {
            Object[] objectArray = new Object[]{this.getPermissionsListString()};
            String string3 = this.getString(R.string.err_write_storage_permission, objectArray);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        }
        ExtentionsKt.showMyDialog$default(context, (String)object2, (String)object, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageCaptureActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageCaptureActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ImageCaptureActivity.access$getPermission(this.this$0);
            }
        }, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getPermissionsListString() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ImageCaptureActivity.Companion.getPermissionsList((Context)this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"."};
            String string3 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string3 == null) {
                string3 = "";
            }
            collection.add(string3);
        }
        String listString = ((List)destination$iv$iv).toString();
        String string4 = listString.substring(1, listString.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return StringsKt.replace$default((String)string4, (String)",", (String)" and ", (boolean)false, (int)4, null);
    }

    private final void showGotoSettingDialog() {
        Object object;
        Context context = (Context)this;
        Object object2 = this.getMImageCaptureConfig();
        if (object2 == null || (object2 = ((ImageCaptureConfig)object2).getSettingPermissionTitle()) == null) {
            String string2 = this.getString(R.string.err_permission_denied);
            object2 = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        }
        if ((object = this.getMImageCaptureConfig()) == null || (object = ((ImageCaptureConfig)object).getSettingPermissionMessage()) == null) {
            Object[] objectArray = new Object[]{this.getPermissionsListString()};
            String string3 = this.getString(R.string.err_write_storage_setting, objectArray);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        }
        ExtentionsKt.showMyDialog(context, (String)object2, (String)object, this.getString(R.string.str_go_to_setting), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageCaptureActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ExtentionsKt.setCanceledResult((Activity)this.this$0, this.this$0.getString(R.string.err_permission_result));
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ImageCaptureActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ImageCaptureActivity.access$getSettingCameraResultLauncher$p(this.this$0).launch((Object)ExtentionsKt.getSettingIntent((Context)this.this$0));
            }
        }));
    }

    private static final void settingCameraResultLauncher$lambda$3(ImageCaptureActivity this$0, ActivityResult it) {
        boolean allGranted;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Iterable $this$all$iv = ImageCaptureActivity.Companion.getPermissionsList((Context)this$0);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String permission = (String)element$iv;
                    boolean bl2 = false;
                    if (ContextCompat.checkSelfPermission((Context)((Context)this$0), (String)permission) == 0) continue;
                    bl = false;
                    break block5;
                }
                bl = allGranted = true;
            }
        }
        if (allGranted) {
            this$0.launchCamera();
        } else {
            ExtentionsKt.setCanceledResult((Activity)this$0, this$0.getString(R.string.err_permission_result));
        }
    }

    public static final /* synthetic */ void access$getPermission(ImageCaptureActivity $this) {
        $this.getPermission();
    }

    public static final /* synthetic */ ActivityResultLauncher access$getSettingCameraResultLauncher$p(ImageCaptureActivity $this) {
        return $this.settingCameraResultLauncher;
    }

    public static final /* synthetic */ void access$launchCamera(ImageCaptureActivity $this) {
        $this.launchCamera();
    }

    public static final /* synthetic */ void access$showAskDialog(ImageCaptureActivity $this) {
        $this.showAskDialog();
    }

    public static final /* synthetic */ void access$showGotoSettingDialog(ImageCaptureActivity $this) {
        $this.showGotoSettingDialog();
    }

    public static final /* synthetic */ Uri access$getImageFileUri$p(ImageCaptureActivity $this) {
        return $this.imageFileUri;
    }

    public static final /* synthetic */ File access$getImageFile$p(ImageCaptureActivity $this) {
        return $this.imageFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J \u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f2\u0006\u0010\r\u001a\u00020\u0006H\u0003\u00a8\u0006\u000e"}, d2={"Lcom/nareshchocha/filepickerlibrary/ui/activitys/ImageCaptureActivity$Companion;", "", "()V", "getInstance", "Landroid/content/Intent;", "mContext", "Landroid/content/Context;", "mImageCaptureConfig", "Lcom/nareshchocha/filepickerlibrary/models/ImageCaptureConfig;", "getPermissionsList", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "context", "filepickerlibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @Keep
        private final ArrayList<String> getPermissionsList(Context context) {
            PackageInfo packageInfo;
            PackageInfo packageInfo2;
            ArrayList<String> arrayList;
            ArrayList<String> it = arrayList = new ArrayList<String>();
            boolean bl = false;
            if (Build.VERSION.SDK_INT <= 29) {
                it.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (Build.VERSION.SDK_INT >= 33) {
                packageInfo2 = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)4096L));
                Intrinsics.checkNotNull((Object)packageInfo2);
                packageInfo = packageInfo2;
            } else {
                packageInfo2 = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
                Intrinsics.checkNotNull((Object)packageInfo2);
                packageInfo = packageInfo2;
            }
            PackageInfo info = packageInfo;
            Object[] permissions = info.requestedPermissions;
            Intrinsics.checkNotNull((Object)permissions);
            if (ArraysKt.contains((Object[])permissions, (Object)"android.permission.CAMERA")) {
                it.add("android.permission.CAMERA");
            }
            return arrayList;
        }

        @Keep
        @NotNull
        public final Intent getInstance(@NotNull Context mContext, @Nullable ImageCaptureConfig mImageCaptureConfig2) {
            Intent filePickerIntent;
            block0: {
                Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
                filePickerIntent = new Intent(mContext, ImageCaptureActivity.class);
                ImageCaptureConfig imageCaptureConfig = mImageCaptureConfig2;
                if (imageCaptureConfig == null) break block0;
                ImageCaptureConfig it = imageCaptureConfig;
                boolean bl = false;
                filePickerIntent.putExtra("IMAGE_CAPTURE", (Parcelable)it);
            }
            return filePickerIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

