/*
 * Decompiled with CFR 0.152.
 */
package com.chaos.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatEditText;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.chaos.view.DefaultMovementMethod;
import com.chaos.view.R;

public class PinView
extends AppCompatEditText {
    private static final String TAG = "PinView";
    private static final boolean DBG = false;
    private static final int BLINK = 500;
    private static final int DEFAULT_COUNT = 4;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final int VIEW_TYPE_RECTANGLE = 0;
    private static final int VIEW_TYPE_LINE = 1;
    private int mViewType;
    private int mPinItemCount;
    private int mPinItemWidth;
    private int mPinItemHeight;
    private int mPinItemRadius;
    private int mPinItemSpacing;
    private final Paint mPaint;
    private final TextPaint mTextPaint;
    private final Paint mAnimatorTextPaint;
    private ColorStateList mLineColor;
    private int mCurLineColor = -16777216;
    private int mLineWidth;
    private final Rect mTextRect = new Rect();
    private final RectF mItemBorderRect = new RectF();
    private final RectF mItemLineRect = new RectF();
    private final Path mPath = new Path();
    private final PointF mItemCenterPoint = new PointF();
    private ValueAnimator mDefaultAddAnimator;
    private boolean isAnimationEnable = false;
    private Blink mBlink;
    private boolean isCursorVisible;
    private boolean drawCursor;
    private float mCursorHeight;
    private int mCursorWidth;
    private int mCursorColor;

    public PinView(Context context) {
        this(context, null);
    }

    public PinView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.pinViewStyle);
    }

    public PinView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mAnimatorTextPaint = new TextPaint((Paint)this.mTextPaint);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.PinView, defStyleAttr, 0);
        this.mViewType = a.getInt(R.styleable.PinView_viewType, 0);
        this.mPinItemCount = a.getInt(R.styleable.PinView_itemCount, 4);
        this.mPinItemHeight = (int)a.getDimension(R.styleable.PinView_itemHeight, (float)res.getDimensionPixelSize(R.dimen.pv_pin_view_item_size));
        this.mPinItemWidth = (int)a.getDimension(R.styleable.PinView_itemWidth, (float)res.getDimensionPixelSize(R.dimen.pv_pin_view_item_size));
        this.mPinItemSpacing = a.getDimensionPixelSize(R.styleable.PinView_itemSpacing, res.getDimensionPixelSize(R.dimen.pv_pin_view_item_spacing));
        this.mPinItemRadius = (int)a.getDimension(R.styleable.PinView_itemRadius, 0.0f);
        this.mLineWidth = (int)a.getDimension(R.styleable.PinView_lineWidth, (float)res.getDimensionPixelSize(R.dimen.pv_pin_view_item_line_width));
        this.mLineColor = a.getColorStateList(R.styleable.PinView_lineColor);
        this.isCursorVisible = a.getBoolean(R.styleable.PinView_android_cursorVisible, true);
        this.mCursorColor = a.getColor(R.styleable.PinView_cursorColor, this.getCurrentTextColor());
        this.mCursorWidth = a.getDimensionPixelSize(R.styleable.PinView_cursorWidth, res.getDimensionPixelSize(R.dimen.pv_pin_view_cursor_width));
        a.recycle();
        if (this.mLineColor != null) {
            this.mCurLineColor = this.mLineColor.getDefaultColor();
        }
        this.updateCursorHeight();
        this.checkItemRadius();
        this.setMaxLength(this.mPinItemCount);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.setupAnimator();
        super.setCursorVisible(false);
        this.setTextIsSelectable(false);
    }

    private void setMaxLength(int maxLength) {
        if (maxLength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
    }

    private void setupAnimator() {
        this.mDefaultAddAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        this.mDefaultAddAnimator.setDuration(150L);
        this.mDefaultAddAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mDefaultAddAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                int alpha = (int)(255.0f * scale);
                PinView.this.mAnimatorTextPaint.setTextSize(PinView.this.getTextSize() * scale);
                PinView.this.mAnimatorTextPaint.setAlpha(alpha);
                PinView.this.postInvalidate();
            }
        });
    }

    private void checkItemRadius() {
        float halfOfLineWidth;
        if (this.mViewType == 1 && (float)this.mPinItemRadius > (halfOfLineWidth = (float)this.mLineWidth / 2.0f)) {
            throw new IllegalArgumentException("The itemRadius can not be greater than lineWidth when viewType is line");
        }
        float halfOfItemWidth = (float)this.mPinItemWidth / 2.0f;
        if ((float)this.mPinItemRadius > halfOfItemWidth) {
            throw new IllegalArgumentException("The itemRadius can not be greater than itemWidth");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int boxHeight = this.mPinItemHeight;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            int boxesWidth = (this.mPinItemCount - 1) * this.mPinItemSpacing + this.mPinItemCount * this.mPinItemWidth;
            width = boxesWidth + ViewCompat.getPaddingEnd((View)this) + ViewCompat.getPaddingStart((View)this);
            if (this.mPinItemSpacing == 0) {
                width -= (this.mPinItemCount - 1) * this.mLineWidth;
            }
        }
        int height = heightMode == 0x40000000 ? heightSize : boxHeight + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (start != text.length()) {
            this.moveSelectionToEnd();
        }
        this.makeBlink();
        if (this.isAnimationEnable) {
            boolean isAdd;
            boolean bl = isAdd = lengthAfter - lengthBefore > 0;
            if (isAdd && this.mDefaultAddAnimator != null) {
                this.mDefaultAddAnimator.end();
                this.mDefaultAddAnimator.start();
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.moveSelectionToEnd();
            this.makeBlink();
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selEnd != this.getText().length()) {
            this.moveSelectionToEnd();
        }
    }

    private void moveSelectionToEnd() {
        this.setSelection(this.getText().length());
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mLineColor == null || this.mLineColor.isStateful()) {
            this.updateColors();
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        this.updatePaints();
        this.drawPinView(canvas);
        canvas.restore();
    }

    private void updatePaints() {
        this.mPaint.setColor(this.mCurLineColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.mTextPaint.setColor(this.getCurrentTextColor());
    }

    private void drawPinView(Canvas canvas) {
        for (int i = 0; i < this.mPinItemCount; ++i) {
            this.updateItemRectF(i);
            this.updateCenterPoint();
            if (this.mViewType == 0) {
                this.drawPinBox(canvas, i);
            } else {
                this.drawPinLine(canvas, i);
            }
            if (this.getText().length() > i) {
                if (PinView.isPasswordInputType(this.getInputType())) {
                    this.drawCircle(canvas, i);
                    continue;
                }
                this.drawText(canvas, i);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)this.getHint()) || this.getHint().length() != this.mPinItemCount) continue;
            this.drawHint(canvas, i);
        }
        if (this.isFocused() && this.getText().length() != this.mPinItemCount) {
            int index = this.getText().length();
            this.updateItemRectF(index);
            this.updateCenterPoint();
            this.mPaint.setColor(this.getLineColorForState(0x10100A1));
            this.drawCursor(canvas);
            if (this.mViewType == 0) {
                this.drawPinBox(canvas, index);
            } else {
                this.drawPinLine(canvas, index);
            }
        }
    }

    private int getLineColorForState(int ... states) {
        return this.mLineColor != null ? this.mLineColor.getColorForState(states, this.mCurLineColor) : this.mCurLineColor;
    }

    private void drawPinBox(Canvas canvas, int i) {
        boolean drawRightCorner = false;
        boolean drawLeftCorner = false;
        if (this.mPinItemSpacing != 0) {
            drawRightCorner = true;
            drawLeftCorner = true;
        } else {
            if (i == 0 && i != this.mPinItemCount - 1) {
                drawLeftCorner = true;
            }
            if (i == this.mPinItemCount - 1 && i != 0) {
                drawRightCorner = true;
            }
        }
        this.updateRoundRectPath(this.mItemBorderRect, this.mPinItemRadius, this.mPinItemRadius, drawLeftCorner, drawRightCorner);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void drawPinLine(Canvas canvas, int i) {
        boolean r = true;
        boolean l = true;
        if (this.mPinItemSpacing == 0 && this.mPinItemCount > 1) {
            if (i == 0) {
                r = false;
            } else if (i == this.mPinItemCount - 1) {
                l = false;
            } else {
                r = false;
                l = false;
            }
        }
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth((float)this.mLineWidth / 10.0f);
        float halfLineWidth = (float)this.mLineWidth / 2.0f;
        this.mItemLineRect.set(this.mItemBorderRect.left, this.mItemBorderRect.bottom - halfLineWidth, this.mItemBorderRect.right, this.mItemBorderRect.bottom + halfLineWidth);
        this.updateRoundRectPath(this.mItemLineRect, this.mPinItemRadius, this.mPinItemRadius, l, r);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void drawCursor(Canvas canvas) {
        if (this.drawCursor) {
            float cx = this.mItemCenterPoint.x;
            float cy = this.mItemCenterPoint.y;
            float x = cx;
            float y = cy - this.mCursorHeight / 2.0f;
            int color = this.mPaint.getColor();
            float width = this.mPaint.getStrokeWidth();
            this.mPaint.setColor(this.mCursorColor);
            this.mPaint.setStrokeWidth((float)this.mCursorWidth);
            canvas.drawLine(x, y, x, y + this.mCursorHeight, this.mPaint);
            this.mPaint.setColor(color);
            this.mPaint.setStrokeWidth(width);
        }
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean l, boolean r) {
        this.updateRoundRectPath(rectF, rx, ry, l, r, r, l);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        this.mPath.reset();
        float l = rectF.left;
        float t = rectF.top;
        float r = rectF.right;
        float b = rectF.bottom;
        float w = r - l;
        float h = b - t;
        float lw = w - 2.0f * rx;
        float lh = h - 2.0f * ry;
        this.mPath.moveTo(l, t + ry);
        if (tl) {
            this.mPath.rQuadTo(0.0f, -ry, rx, -ry);
        } else {
            this.mPath.rLineTo(0.0f, -ry);
            this.mPath.rLineTo(rx, 0.0f);
        }
        this.mPath.rLineTo(lw, 0.0f);
        if (tr) {
            this.mPath.rQuadTo(rx, 0.0f, rx, ry);
        } else {
            this.mPath.rLineTo(rx, 0.0f);
            this.mPath.rLineTo(0.0f, ry);
        }
        this.mPath.rLineTo(0.0f, lh);
        if (br) {
            this.mPath.rQuadTo(0.0f, ry, -rx, ry);
        } else {
            this.mPath.rLineTo(0.0f, ry);
            this.mPath.rLineTo(-rx, 0.0f);
        }
        this.mPath.rLineTo(-lw, 0.0f);
        if (bl) {
            this.mPath.rQuadTo(-rx, 0.0f, -rx, -ry);
        } else {
            this.mPath.rLineTo(-rx, 0.0f);
            this.mPath.rLineTo(0.0f, -ry);
        }
        this.mPath.rLineTo(0.0f, -lh);
        this.mPath.close();
    }

    private void updateItemRectF(int i) {
        float halfLineWidth = (float)this.mLineWidth / 2.0f;
        float left = (float)(this.getScrollX() + ViewCompat.getPaddingStart((View)this) + i * (this.mPinItemSpacing + this.mPinItemWidth)) + halfLineWidth;
        if (this.mPinItemSpacing == 0 && i > 0) {
            left -= (float)(this.mLineWidth * i);
        }
        float right = left + (float)this.mPinItemWidth - (float)this.mLineWidth;
        float top = (float)(this.getScrollY() + this.getPaddingTop()) + halfLineWidth;
        float bottom = top + (float)this.mPinItemHeight - (float)this.mLineWidth;
        this.mItemBorderRect.set(left, top, right, bottom);
    }

    private void drawText(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        this.drawTextAtBox(canvas, paint, (CharSequence)this.getText(), i);
    }

    private void drawHint(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentHintTextColor());
        this.drawTextAtBox(canvas, paint, this.getHint(), i);
    }

    private void drawTextAtBox(Canvas canvas, Paint paint, CharSequence text, int charAt) {
        paint.getTextBounds(text.toString(), charAt, charAt + 1, this.mTextRect);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        float x = cx - Math.abs((float)this.mTextRect.width()) / 2.0f - (float)this.mTextRect.left;
        float y = cy + Math.abs((float)this.mTextRect.height()) / 2.0f - (float)this.mTextRect.bottom;
        canvas.drawText(text, charAt, charAt + 1, x, y, paint);
    }

    private void drawCircle(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        canvas.drawCircle(cx, cy, paint.getTextSize() / 2.0f, paint);
    }

    private Paint getPaintByIndex(int i) {
        if (this.isAnimationEnable && i == this.getText().length() - 1) {
            this.mAnimatorTextPaint.setColor(this.mTextPaint.getColor());
            return this.mAnimatorTextPaint;
        }
        return this.mTextPaint;
    }

    private void drawAnchorLine(Canvas canvas) {
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        this.mPaint.setStrokeWidth(1.0f);
        cy -= this.mPaint.getStrokeWidth() / 2.0f;
        this.mPath.reset();
        this.mPath.moveTo(cx -= this.mPaint.getStrokeWidth() / 2.0f, this.mItemBorderRect.top);
        this.mPath.lineTo(cx, this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()));
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPath.moveTo(this.mItemBorderRect.left, cy);
        this.mPath.lineTo(this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()), cy);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
    }

    private void updateColors() {
        boolean inval = false;
        int color = this.mLineColor != null ? this.mLineColor.getColorForState(this.getDrawableState(), 0) : this.getCurrentTextColor();
        if (color != this.mCurLineColor) {
            this.mCurLineColor = color;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    private void updateCenterPoint() {
        float cx = this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()) / 2.0f;
        float cy = this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()) / 2.0f;
        this.mItemCenterPoint.set(cx, cy);
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return DefaultMovementMethod.getInstance();
    }

    public void setLineColor(@ColorInt int color) {
        this.mLineColor = ColorStateList.valueOf((int)color);
        this.updateColors();
    }

    public void setLineColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mLineColor = colors;
        this.updateColors();
    }

    public ColorStateList getLineColors() {
        return this.mLineColor;
    }

    @ColorInt
    public int getCurrentLineColor() {
        return this.mCurLineColor;
    }

    public void setLineWidth(@Px int borderWidth) {
        this.mLineWidth = borderWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getLineWidth() {
        return this.mLineWidth;
    }

    public void setItemCount(int count) {
        this.mPinItemCount = count;
        this.setMaxLength(count);
        this.requestLayout();
    }

    public int getItemCount() {
        return this.mPinItemCount;
    }

    public void setItemRadius(@Px int itemRadius) {
        this.mPinItemRadius = itemRadius;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getItemRadius() {
        return this.mPinItemRadius;
    }

    public void setItemSpacing(@Px int itemSpacing) {
        this.mPinItemSpacing = itemSpacing;
        this.requestLayout();
    }

    @Px
    public int getItemSpacing() {
        return this.mPinItemSpacing;
    }

    public void setItemHeight(@Px int itemHeight) {
        this.mPinItemHeight = itemHeight;
        this.updateCursorHeight();
        this.requestLayout();
    }

    public int getItemHeight() {
        return this.mPinItemHeight;
    }

    public void setItemWidth(@Px int itemWidth) {
        this.mPinItemWidth = itemWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getItemWidth() {
        return this.mPinItemWidth;
    }

    public void setAnimationEnable(boolean enable) {
        this.isAnimationEnable = enable;
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.updateCursorHeight();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        this.updateCursorHeight();
    }

    public void setCursorWidth(@Px int width) {
        this.mCursorWidth = width;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    public int getCursorWidth() {
        return this.mCursorWidth;
    }

    public void setCursorColor(@ColorInt int color) {
        this.mCursorColor = color;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    public int getCursorColor() {
        return this.mCursorColor;
    }

    public void setCursorVisible(boolean visible) {
        if (this.isCursorVisible != visible) {
            this.isCursorVisible = visible;
            this.invalidateCursor(this.isCursorVisible);
            this.makeBlink();
        }
    }

    public boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        switch (screenState) {
            case 1: {
                this.resumeBlink();
                break;
            }
            case 0: {
                this.suspendBlink();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resumeBlink();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.suspendBlink();
    }

    private boolean shouldBlink() {
        return this.isCursorVisible() && this.isFocused();
    }

    private void makeBlink() {
        if (this.shouldBlink()) {
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.removeCallbacks(this.mBlink);
            this.drawCursor = false;
            this.postDelayed(this.mBlink, 500L);
        } else if (this.mBlink != null) {
            this.removeCallbacks(this.mBlink);
        }
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
            this.invalidateCursor(false);
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    private void invalidateCursor(boolean showCursor) {
        if (this.drawCursor != showCursor) {
            this.drawCursor = showCursor;
            this.invalidate();
        }
    }

    private void updateCursorHeight() {
        int delta = 2 * this.dpToPx(2.0f);
        this.mCursorHeight = (float)this.mPinItemHeight - this.getTextSize() > (float)delta ? this.getTextSize() + (float)delta : this.getTextSize();
    }

    private int dpToPx(float dp) {
        return (int)(dp * this.getResources().getDisplayMetrics().density + 0.5f);
    }

    private class Blink
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        @Override
        public void run() {
            if (this.mCancelled) {
                return;
            }
            PinView.this.removeCallbacks(this);
            if (PinView.this.shouldBlink()) {
                PinView.this.invalidateCursor(!PinView.this.drawCursor);
                PinView.this.postDelayed(this, 500L);
            }
        }

        private void cancel() {
            if (!this.mCancelled) {
                PinView.this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }
}

