/*
 * Decompiled with CFR 0.152.
 */
package com.chaos.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.v7.widget.AppCompatEditText;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.chaos.view.R;

public class PinView
extends AppCompatEditText {
    private static final String TAG = "PinView";
    private static final boolean DBG = false;
    private static final int DEFAULT_COUNT = 4;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final int VIEW_TYPE_RECTANGLE = 0;
    private static final int VIEW_TYPE_LINE = 1;
    private int mViewType;
    private int mPinItemCount;
    private float mPinItemSize;
    private float mPinItemWidth;
    private float mPinItemHeight;
    private int mPinItemRadius;
    private int mPinItemSpacing;
    private final Paint mPaint;
    private final TextPaint mTextPaint;
    private final Paint mAnimatorTextPaint;
    private ColorStateList mLineColor;
    private int mCurLineColor = -16777216;
    private int mLineWidth;
    private final Rect mTextRect = new Rect();
    private final RectF mItemBorderRect = new RectF();
    private final RectF mItemLineRect = new RectF();
    private final Path mPath = new Path();
    private final PointF mItemCenterPoint = new PointF();
    private ValueAnimator mDefaultAddAnimator;
    private boolean isAnimationEnable = false;

    public PinView(Context context) {
        this(context, null);
    }

    public PinView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.pinViewStyle);
    }

    public PinView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = res.getDisplayMetrics().density;
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize(this.getTextSize());
        this.mAnimatorTextPaint = new TextPaint((Paint)this.mTextPaint);
        Resources.Theme theme = context.getTheme();
        TypedArray a = theme.obtainStyledAttributes(attrs, R.styleable.PinView, defStyleAttr, 0);
        this.mViewType = a.getInt(R.styleable.PinView_viewType, 0);
        this.mPinItemCount = a.getInt(R.styleable.PinView_itemCount, 4);
        this.mPinItemHeight = this.mPinItemWidth = (this.mPinItemSize = (float)a.getDimensionPixelSize(R.styleable.PinView_itemSize, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_size)));
        if (a.hasValue(R.styleable.PinView_itemHeight)) {
            this.mPinItemHeight = a.getDimensionPixelOffset(R.styleable.PinView_itemHeight, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_size));
        }
        if (a.hasValue(R.styleable.PinView_itemWidth)) {
            this.mPinItemWidth = a.getDimensionPixelOffset(R.styleable.PinView_itemWidth, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_size));
        }
        this.mPinItemSpacing = a.getDimensionPixelOffset(R.styleable.PinView_itemSpacing, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_spacing));
        this.mPinItemRadius = a.getDimensionPixelOffset(R.styleable.PinView_itemRadius, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_radius));
        this.mLineWidth = a.getDimensionPixelOffset(R.styleable.PinView_borderWidth, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_line_width));
        this.mLineColor = a.getColorStateList(R.styleable.PinView_borderColor);
        if (a.hasValue(R.styleable.PinView_lineWidth)) {
            this.mLineWidth = a.getDimensionPixelOffset(R.styleable.PinView_lineWidth, res.getDimensionPixelOffset(R.dimen.pv_pin_view_item_line_width));
        }
        if (a.hasValue(R.styleable.PinView_lineColor)) {
            this.mLineColor = a.getColorStateList(R.styleable.PinView_lineColor);
        }
        a.recycle();
        this.setMaxLength(this.mPinItemCount);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.setupAnimator();
        this.setCursorVisible(false);
        this.setTextIsSelectable(false);
    }

    private void setMaxLength(int maxLength) {
        if (maxLength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
    }

    private void setupAnimator() {
        this.mDefaultAddAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        this.mDefaultAddAnimator.setDuration(150L);
        this.mDefaultAddAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.mDefaultAddAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                int alpha = (int)(255.0f * scale);
                PinView.this.mAnimatorTextPaint.setTextSize(PinView.this.getTextSize() * scale);
                PinView.this.mAnimatorTextPaint.setAlpha(alpha);
                PinView.this.postInvalidate();
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float boxHeight = this.mPinItemHeight;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            float boxesWidth = (float)((this.mPinItemCount - 1) * this.mPinItemSpacing) + (float)this.mPinItemCount * this.mPinItemWidth;
            width = Math.round(boxesWidth + (float)this.getPaddingRight() + (float)this.getPaddingLeft());
            if (this.mPinItemSpacing == 0) {
                width -= (this.mPinItemCount - 1) * this.mLineWidth;
            }
        }
        int height = heightMode == 0x40000000 ? heightSize : Math.round(boxHeight + (float)this.getPaddingTop() + (float)this.getPaddingBottom());
        this.setMeasuredDimension(width, height);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (start != text.length()) {
            this.moveCursorToEnd();
        }
        if (this.isAnimationEnable) {
            boolean isAdd;
            boolean bl = isAdd = lengthAfter - lengthBefore > 0;
            if (isAdd && this.mDefaultAddAnimator != null) {
                this.mDefaultAddAnimator.end();
                this.mDefaultAddAnimator.start();
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.moveCursorToEnd();
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selEnd != this.getText().length()) {
            this.moveCursorToEnd();
        }
    }

    private void moveCursorToEnd() {
        this.setSelection(this.getText().length());
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mLineColor == null || this.mLineColor.isStateful()) {
            this.updateColors();
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        this.updatePaints();
        this.drawPinView(canvas);
        canvas.restore();
    }

    private void updatePaints() {
        this.mPaint.setColor(this.mCurLineColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
        this.mTextPaint.setColor(this.getCurrentTextColor());
    }

    private void drawPinView(Canvas canvas) {
        if (this.mViewType == 0 && this.mPinItemSpacing == 0 && this.mPinItemCount > 1) {
            this.drawWholeBoxView(canvas);
        }
        for (int i = 0; i < this.mPinItemCount; ++i) {
            this.updateItemRectF(i);
            this.updateCenterPoint();
            if (this.mViewType == 0) {
                if (this.mPinItemSpacing != 0) {
                    this.drawPerPinBox(canvas);
                }
            } else {
                this.drawPinLine(canvas, i);
            }
            if (this.getText().length() > i) {
                if (PinView.isPasswordInputType(this.getInputType())) {
                    this.drawCircle(canvas, i);
                    continue;
                }
                this.drawText(canvas, i);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)this.getHint()) || this.getHint().length() != this.mPinItemCount) continue;
            this.drawHint(canvas, i);
        }
    }

    private void drawWholeBoxView(Canvas canvas) {
        float halfLineWidth = (float)this.mLineWidth / 2.0f;
        float left = (float)this.getPaddingLeft() + halfLineWidth;
        float right = left + (float)this.getWidth() - (float)this.getPaddingLeft() - (float)this.getPaddingRight() - (float)this.mLineWidth;
        float top = (float)this.getPaddingTop() + halfLineWidth;
        float bottom = top + this.mPinItemHeight - (float)this.mLineWidth;
        this.mItemBorderRect.set(left, top, right, bottom);
        this.updateRoundRectPath(this.mItemBorderRect, this.mPinItemRadius, this.mPinItemRadius, true, true);
        for (int i = 1; i < this.mPinItemCount; ++i) {
            this.mPath.moveTo(this.mItemBorderRect.left + (this.mPinItemWidth - (float)this.mLineWidth) * (float)i, this.mItemBorderRect.top - (float)(this.mLineWidth / 2));
            this.mPath.rLineTo(0.0f, this.mPinItemHeight - (float)this.mLineWidth);
        }
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void drawPerPinBox(Canvas canvas) {
        this.updateRoundRectPath(this.mItemBorderRect, this.mPinItemRadius, this.mPinItemRadius, true, true);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void drawPinLine(Canvas canvas, int i) {
        boolean r = true;
        boolean l = true;
        if (this.mPinItemSpacing == 0 && this.mPinItemCount > 1) {
            if (i == 0) {
                r = false;
            } else if (i == this.mPinItemCount - 1) {
                l = false;
            } else {
                r = false;
                l = false;
            }
        }
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth((float)this.mLineWidth / 10.0f);
        float halfLineWidth = (float)this.mLineWidth / 2.0f;
        this.mItemLineRect.set(this.mItemBorderRect.left, this.mItemBorderRect.bottom - halfLineWidth, this.mItemBorderRect.right, this.mItemBorderRect.bottom + halfLineWidth);
        this.updateRoundRectPath(this.mItemLineRect, this.mPinItemRadius, this.mPinItemRadius, l, r);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean l, boolean r) {
        this.updateRoundRectPath(rectF, rx, ry, l, r, r, l);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        this.mPath.reset();
        float l = rectF.left;
        float t = rectF.top;
        float r = rectF.right;
        float b = rectF.bottom;
        float w = r - l;
        float h = b - t;
        float lw = w - 2.0f * rx;
        float lh = h - 2.0f * ry;
        this.mPath.moveTo(l, t + ry);
        if (tl) {
            this.mPath.rQuadTo(0.0f, -ry, rx, -ry);
        } else {
            this.mPath.rLineTo(0.0f, -ry);
            this.mPath.rLineTo(rx, 0.0f);
        }
        this.mPath.rLineTo(lw, 0.0f);
        if (tr) {
            this.mPath.rQuadTo(rx, 0.0f, rx, ry);
        } else {
            this.mPath.rLineTo(rx, 0.0f);
            this.mPath.rLineTo(0.0f, ry);
        }
        this.mPath.rLineTo(0.0f, lh);
        if (br) {
            this.mPath.rQuadTo(0.0f, ry, -rx, ry);
        } else {
            this.mPath.rLineTo(0.0f, ry);
            this.mPath.rLineTo(-rx, 0.0f);
        }
        this.mPath.rLineTo(-lw, 0.0f);
        if (bl) {
            this.mPath.rQuadTo(-rx, 0.0f, -rx, -ry);
        } else {
            this.mPath.rLineTo(-rx, 0.0f);
            this.mPath.rLineTo(0.0f, -ry);
        }
        this.mPath.rLineTo(0.0f, -lh);
        this.mPath.close();
    }

    private void updateItemRectF(int i) {
        float halfLineWidth = (float)this.mLineWidth / 2.0f;
        float left = (float)this.getPaddingLeft() + (float)i * ((float)this.mPinItemSpacing + this.mPinItemWidth) + halfLineWidth;
        if (this.mPinItemSpacing == 0 && i > 0) {
            left -= (float)(this.mLineWidth * i);
        }
        float right = left + this.mPinItemWidth - (float)this.mLineWidth;
        float top = (float)this.getPaddingTop() + halfLineWidth;
        float bottom = top + this.mPinItemHeight - (float)this.mLineWidth;
        this.mItemBorderRect.set(left, top, right, bottom);
    }

    private void drawText(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        this.drawTextAtBox(canvas, paint, (CharSequence)this.getText(), i);
    }

    private void drawHint(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentHintTextColor());
        this.drawTextAtBox(canvas, paint, this.getHint(), i);
    }

    private void drawTextAtBox(Canvas canvas, Paint paint, CharSequence text, int charAt) {
        paint.getTextBounds(text.toString(), charAt, charAt + 1, this.mTextRect);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        float x = cx - (float)(Math.abs(this.mTextRect.width()) / 2) - (float)this.mTextRect.left;
        float y = cy + (float)(Math.abs(this.mTextRect.height()) / 2) - (float)this.mTextRect.bottom;
        canvas.drawText(text, charAt, charAt + 1, x, y, paint);
    }

    private void drawCircle(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        canvas.drawCircle(cx, cy, paint.getTextSize() / 2.0f, paint);
    }

    private Paint getPaintByIndex(int i) {
        if (this.isAnimationEnable && i == this.getText().length() - 1) {
            this.mAnimatorTextPaint.setColor(this.mTextPaint.getColor());
            return this.mAnimatorTextPaint;
        }
        return this.mTextPaint;
    }

    private void drawAnchorLine(Canvas canvas) {
        float cx = this.mItemCenterPoint.x;
        float cy = this.mItemCenterPoint.y;
        this.mPaint.setStrokeWidth(1.0f);
        cy -= this.mPaint.getStrokeWidth() / 2.0f;
        this.mPath.reset();
        this.mPath.moveTo(cx -= this.mPaint.getStrokeWidth() / 2.0f, this.mItemBorderRect.top);
        this.mPath.lineTo(cx, this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()));
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPath.moveTo(this.mItemBorderRect.left, cy);
        this.mPath.lineTo(this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()), cy);
        canvas.drawPath(this.mPath, this.mPaint);
        this.mPath.reset();
        this.mPaint.setStrokeWidth((float)this.mLineWidth);
    }

    private void updateColors() {
        boolean inval = false;
        int color = this.mLineColor != null ? this.mLineColor.getColorForState(this.getDrawableState(), 0) : this.getCurrentTextColor();
        if (color != this.mCurLineColor) {
            this.mCurLineColor = color;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    private void updateCenterPoint() {
        float cx = this.mItemBorderRect.left + Math.abs(this.mItemBorderRect.width()) / 2.0f;
        float cy = this.mItemBorderRect.top + Math.abs(this.mItemBorderRect.height()) / 2.0f;
        this.mItemCenterPoint.set(cx, cy);
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return null;
    }

    @Deprecated
    public void setBorderColor(@ColorInt int color) {
        this.setLineColor(color);
    }

    @Deprecated
    public void setBorderColor(ColorStateList colors) {
        this.setLineColor(colors);
    }

    @Deprecated
    public ColorStateList getBorderColors() {
        return this.getLineColors();
    }

    @Deprecated
    @ColorInt
    public int getCurrentBorderColor() {
        return this.getCurrentLineColor();
    }

    public void setLineColor(@ColorInt int color) {
        this.mLineColor = ColorStateList.valueOf((int)color);
        this.updateColors();
    }

    public void setLineColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mLineColor = colors;
        this.updateColors();
    }

    public ColorStateList getLineColors() {
        return this.mLineColor;
    }

    @ColorInt
    public int getCurrentLineColor() {
        return this.mCurLineColor;
    }

    @Deprecated
    public void setBorderWidth(@Px int borderWidth) {
        this.setLineWidth(borderWidth);
    }

    @Deprecated
    @Px
    public int getBorderWidth() {
        return this.getLineWidth();
    }

    public void setLineWidth(@Px int borderWidth) {
        this.mLineWidth = borderWidth;
        this.requestLayout();
    }

    @Px
    public int getLineWidth() {
        return this.mLineWidth;
    }

    public void setItemCount(int count) {
        this.mPinItemCount = count;
        this.setMaxLength(count);
        this.requestLayout();
    }

    public int getItemCount() {
        return this.mPinItemCount;
    }

    public void setItemRadius(@Px int itemRadius) {
        this.mPinItemRadius = itemRadius;
        this.requestLayout();
    }

    @Px
    public int getItemRadius() {
        return this.mPinItemRadius;
    }

    public void setItemSpacing(@Px int itemSpacing) {
        this.mPinItemSpacing = itemSpacing;
        this.requestLayout();
    }

    @Px
    public int getItemSpacing() {
        return this.mPinItemSpacing;
    }

    @Deprecated
    public void setItemSize(float itemSize) {
        this.mPinItemHeight = this.mPinItemSize = itemSize;
        this.mPinItemWidth = this.mPinItemSize;
        this.requestLayout();
    }

    @Deprecated
    public float getItemSize() {
        return this.mPinItemSize;
    }

    public void setItemHeight(float itemHeight) {
        this.mPinItemHeight = itemHeight;
        this.requestLayout();
    }

    public float getItemHeight() {
        return this.mPinItemHeight;
    }

    public void setItemWidth(float itemWidth) {
        this.mPinItemWidth = itemWidth;
        this.requestLayout();
    }

    public float getItemWidth() {
        return this.mPinItemWidth;
    }

    public void setAnimationEnable(boolean enable) {
        this.isAnimationEnable = enable;
    }
}

