/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotenvParser {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("^\\s*$");
    private static final Pattern DOTENV_ENTRY_REGEX = Pattern.compile("^\\s*([\\w.\\-]+)\\s*(=)\\s*(.*)?\\s*$");
    private final DotenvReader reader;
    private final boolean throwIfMissing;
    private final boolean throwIfMalformed;
    private final Predicate<String> isWhiteSpace = s -> DotenvParser.matches(WHITE_SPACE_REGEX, s);
    private final Predicate<String> isComment = s -> s.startsWith("#") || s.startsWith("////");
    private final Predicate<String> isQuoted = s -> s.startsWith("\"") && s.endsWith("\"");
    private final Function<String, DotenvEntry> parseLine = s -> DotenvParser.matchEntry(DOTENV_ENTRY_REGEX, s);

    public DotenvParser(DotenvReader reader, boolean throwIfMissing, boolean throwIfMalformed) {
        this.reader = reader;
        this.throwIfMissing = throwIfMissing;
        this.throwIfMalformed = throwIfMalformed;
    }

    public List<DotenvEntry> parse() throws DotenvException {
        ArrayList<DotenvEntry> entries = new ArrayList<DotenvEntry>();
        for (String line : this.lines()) {
            String l = line.trim();
            if (this.isWhiteSpace.test(l) || this.isComment.test(l) || DotenvParser.isBlank(l)) continue;
            DotenvEntry entry = this.parseLine.apply(l);
            if (entry == null) {
                if (!this.throwIfMalformed) continue;
                throw new DotenvException("Malformed entry " + l);
            }
            String key = entry.getKey();
            String value = this.normalizeValue(entry.getValue());
            entries.add(new DotenvEntry(key, value));
        }
        return entries;
    }

    private List<String> lines() throws DotenvException {
        try {
            return this.reader.read();
        }
        catch (DotenvException e) {
            if (this.throwIfMissing) {
                throw e;
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new DotenvException(e);
        }
    }

    private String normalizeValue(String value) {
        String tr = value.trim();
        return this.isQuoted.test(tr) ? tr.substring(1, value.length() - 1) : tr;
    }

    private static boolean matches(Pattern regex, String text) {
        Matcher matcher = regex.matcher(text);
        return matcher.matches();
    }

    private static DotenvEntry matchEntry(Pattern regex, String text) {
        Matcher matcher = regex.matcher(text);
        boolean result = matcher.matches();
        if (!result || matcher.groupCount() < 3) {
            return null;
        }
        return new DotenvEntry(matcher.group(1), matcher.group(3));
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

