/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.internal.servlet5;

import io.github.cdiunit.internal.servlet.common.ExceptionUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MockServletOutputStream
extends ServletOutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private String encoding;

    public MockServletOutputStream() {
        this("ISO-8859-1");
    }

    public MockServletOutputStream(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void write(int value) throws IOException {
        this.buffer.write(value);
    }

    public String getContent() {
        try {
            this.buffer.flush();
            return this.buffer.toString(this.encoding);
        }
        catch (IOException exc) {
            throw ExceptionUtils.asRuntimeException(exc);
        }
    }

    public byte[] getBinaryContent() {
        try {
            this.buffer.flush();
            return this.buffer.toByteArray();
        }
        catch (IOException exc) {
            throw ExceptionUtils.asRuntimeException(exc);
        }
    }

    public void clearContent() {
        this.buffer = new ByteArrayOutputStream();
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

