/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.spock.internal;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.internal.activatescopes.ScopesHelper;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.IStore;

public class ActivateScopes
implements IMethodInterceptor {
    private final IStore.Namespace namespace;

    public ActivateScopes(IStore.Namespace namespace) {
        this.namespace = namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(IMethodInvocation invocation) throws Throwable {
        IStore store = invocation.getStore(this.namespace);
        TestLifecycle testLifecycle = (TestLifecycle)store.get((Object)invocation, TestLifecycle.class);
        if (testLifecycle == null) {
            throw new IllegalStateException(String.format("no test lifecycle bound to %s", invocation));
        }
        Method method = testLifecycle.getTestMethod();
        if (method == null) {
            invocation.proceed();
            return;
        }
        AtomicBoolean contextsActivated = (AtomicBoolean)store.getOrComputeIfAbsent((Object)testLifecycle, c -> new AtomicBoolean());
        IsolationLevel isolationLevel = testLifecycle.getIsolationLevel();
        BeanManager beanManager = testLifecycle.getBeanManager();
        try {
            if (!contextsActivated.get()) {
                ScopesHelper.activateContexts((BeanManager)beanManager, (Object)method);
                contextsActivated.set(true);
            }
            invocation.proceed();
        }
        finally {
            if (contextsActivated.get() && isolationLevel == IsolationLevel.PER_METHOD) {
                contextsActivated.set(false);
                ScopesHelper.deactivateContexts((BeanManager)beanManager, (Object)method);
            }
        }
    }
}

