/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit5.internal;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.activatescopes.ScopesHelper;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.InvocationInterceptor;

public class ActivateScopes
implements InvocationInterceptor.Invocation<Void> {
    private final InvocationInterceptor.Invocation<Void> next;
    private final TestConfiguration testConfiguration;
    private final AtomicBoolean contextsActivated;
    private final Supplier<BeanManager> beanManager;

    public ActivateScopes(InvocationInterceptor.Invocation<Void> next, TestConfiguration testConfiguration, AtomicBoolean contextsActivated, Supplier<BeanManager> beanManager) {
        this.next = next;
        this.testConfiguration = testConfiguration;
        this.contextsActivated = contextsActivated;
        this.beanManager = beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void proceed() throws Throwable {
        Method method = this.testConfiguration.getTestMethod();
        IsolationLevel isolationLevel = this.testConfiguration.getIsolationLevel();
        try {
            if (!this.contextsActivated.get()) {
                ScopesHelper.activateContexts((BeanManager)this.beanManager.get(), (Object)method);
                this.contextsActivated.set(true);
            }
            Void void_ = (Void)this.next.proceed();
            return void_;
        }
        finally {
            if (this.contextsActivated.get() && isolationLevel == IsolationLevel.PER_METHOD) {
                this.contextsActivated.set(false);
                ScopesHelper.deactivateContexts((BeanManager)this.beanManager.get(), (Object)method);
            }
        }
    }
}

