/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.junit5;

import io.github.cdiunit.IsolationLevel;
import io.github.cdiunit.internal.TestConfiguration;
import io.github.cdiunit.internal.TestLifecycle;
import io.github.cdiunit.junit5.internal.ActivateScopes;
import io.github.cdiunit.junit5.internal.InvokeInterceptors;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstanceFactory;
import org.junit.jupiter.api.extension.TestInstanceFactoryContext;
import org.junit.jupiter.api.extension.TestInstantiationException;
import org.junit.platform.commons.support.AnnotationSupport;

public class CdiJUnit5Extension
implements TestInstanceFactory,
BeforeEachCallback,
BeforeAllCallback,
AfterEachCallback,
AfterAllCallback,
InvocationInterceptor {
    private final Map<Class<?>, JupiterTestLifecycle> testLifecycles = new ConcurrentHashMap();

    private JupiterTestLifecycle initialTestLifecycle(Class<?> testClass) {
        return this.testLifecycles.computeIfAbsent(testClass, aClass -> new JupiterTestLifecycle(new TestConfiguration(aClass, null)));
    }

    private JupiterTestLifecycle requiredTestLifecycle(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        JupiterTestLifecycle testLifecycle = this.initialTestLifecycle(testClass);
        context.getTestMethod().ifPresent(arg_0 -> ((JupiterTestLifecycle)testLifecycle).setTestMethod(arg_0));
        return testLifecycle;
    }

    public Object createTestInstance(TestInstanceFactoryContext factoryContext, ExtensionContext extensionContext) throws TestInstantiationException {
        JupiterTestLifecycle testLifecycle = this.initialTestLifecycle(factoryContext.getTestClass());
        Object outerInstance = factoryContext.getOuterInstance().orElse(null);
        try {
            return testLifecycle.createTest(outerInstance);
        }
        catch (Throwable t) {
            throw new TestInstantiationException(t.getMessage(), t);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        JupiterTestLifecycle testLifecycle = this.requiredTestLifecycle(context);
        testLifecycle.beforeTestClass();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        JupiterTestLifecycle testLifecycle = this.requiredTestLifecycle(context);
        testLifecycle.afterTestClass();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        JupiterTestLifecycle testLifecycle = this.requiredTestLifecycle(context);
        testLifecycle.beforeTestMethod();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        JupiterTestLifecycle testLifecycle = this.requiredTestLifecycle(context);
        testLifecycle.afterTestMethod();
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestLifecycle testLifecycle = this.requiredTestLifecycle(extensionContext);
        testLifecycle.interceptTestMethod(invocation, invocationContext);
    }

    static class JupiterTestLifecycle
    extends TestLifecycle {
        AtomicBoolean contextsActivated = new AtomicBoolean();

        protected JupiterTestLifecycle(TestConfiguration testConfiguration) {
            super(testConfiguration);
            this.configureIsolationLevel(testConfiguration.getTestClass());
        }

        private void configureIsolationLevel(Class<?> testClass) {
            TestInstance.Lifecycle testInstanceIsolation;
            TestInstance.Lifecycle defaultTestLifecycle = TestInstance.Lifecycle.PER_METHOD;
            String defaultTestLifecycleProperty = System.getProperty("junit.jupiter.testinstance.lifecycle.default");
            if (defaultTestLifecycleProperty != null) {
                defaultTestLifecycle = TestInstance.Lifecycle.valueOf((String)defaultTestLifecycleProperty.toUpperCase(Locale.ROOT));
            }
            if ((testInstanceIsolation = AnnotationSupport.findAnnotation(testClass, TestInstance.class).map(TestInstance::value).orElse(defaultTestLifecycle)) == TestInstance.Lifecycle.PER_CLASS) {
                this.setIsolationLevel(IsolationLevel.PER_CLASS);
            }
        }

        void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext) throws Throwable {
            if (this.explicitInterceptorInvocation()) {
                invocation = new InvokeInterceptors((InvocationInterceptor.Invocation<Void>)invocation, invocationContext, this);
            }
            invocation = new ActivateScopes((InvocationInterceptor.Invocation<Void>)invocation, this.getTestConfiguration(), this.contextsActivated, () -> ((JupiterTestLifecycle)this).getBeanManager());
            invocation.proceed();
        }
    }
}

