/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdiunit.deltaspike.internal;

import io.github.cdiunit.internal.ClassLookup;
import io.github.cdiunit.internal.DiscoveryExtension;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeltaspikeScopeDiscoveryExtension
implements DiscoveryExtension {
    private final Class<? extends Annotation> windowScopedAnnotation = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.api.scope.WindowScoped");
    private final Class<? extends Annotation> viewAccessScopedAnnotation = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.api.scope.ViewAccessScoped");
    private final Class<? extends Annotation> groupedConversationScopedAnnotation = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.api.scope.GroupedConversationScoped");
    private final List<Class<?>> supportClassesToLoad = Stream.of("org.apache.deltaspike.core.impl.scope.conversation.ConversationBeanHolder", "org.apache.deltaspike.core.impl.scope.viewaccess.ViewAccessBeanHolder", "org.apache.deltaspike.core.impl.scope.window.WindowBeanHolder").map(arg_0 -> ((ClassLookup)ClassLookup.INSTANCE).lookup(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    private final Class<?> windowContext = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.spi.scope.window.WindowContext");
    private final Class<?> viewAccessContextManager = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.spi.scope.viewaccess.ViewAccessContextManager");
    private final Class<?> groupedConversationManager = ClassLookup.INSTANCE.lookup("org.apache.deltaspike.core.spi.scope.conversation.GroupedConversationManager");

    public void bootstrap(DiscoveryExtension.BootstrapDiscoveryContext bdc) {
        bdc.discoverClass(this::discoverAnnotated);
        bdc.discoverField(this::discoverAnnotated);
        bdc.discoverField(this::discoverField);
        bdc.discoverMethod(this::discoverAnnotated);
    }

    private void discoverAnnotated(DiscoveryExtension.Context context, AnnotatedElement e) {
        boolean matchingAnnotationPresent;
        boolean bl = matchingAnnotationPresent = DeltaspikeScopeDiscoveryExtension.isAnnotationPresent(e, this.windowScopedAnnotation) || DeltaspikeScopeDiscoveryExtension.isAnnotationPresent(e, this.viewAccessScopedAnnotation) || DeltaspikeScopeDiscoveryExtension.isAnnotationPresent(e, this.groupedConversationScopedAnnotation);
        if (matchingAnnotationPresent) {
            context.scanPackages(this.supportClassesToLoad).forEach(arg_0 -> ((DiscoveryExtension.Context)context).processBean(arg_0));
        }
    }

    private static boolean isAnnotationPresent(AnnotatedElement e, Class<? extends Annotation> a) {
        if (e == null || a == null) {
            return false;
        }
        return e.isAnnotationPresent(a);
    }

    private boolean typeMatches(Class<?> t) {
        return this.windowContext != null && this.windowContext.isAssignableFrom(t) || this.viewAccessContextManager != null && this.viewAccessContextManager.isAssignableFrom(t) || this.groupedConversationManager != null && this.groupedConversationManager.isAssignableFrom(t);
    }

    private void discoverField(DiscoveryExtension.Context context, Field field) {
        if (field.isAnnotationPresent(Inject.class) && this.typeMatches(field.getType())) {
            context.scanPackages(this.supportClassesToLoad).forEach(arg_0 -> ((DiscoveryExtension.Context)context).processBean(arg_0));
        }
    }
}

