/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.domain.UnpagedPageImpl;
import org.socialsignin.spring.data.dynamodb.exception.BatchDeleteException;
import org.socialsignin.spring.data.dynamodb.query.Query;
import org.socialsignin.spring.data.dynamodb.repository.query.DynamoDBQueryMethod;
import org.socialsignin.spring.data.dynamodb.utils.ExceptionHandler;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractDynamoDBQuery<T, ID>
implements RepositoryQuery,
ExceptionHandler {
    protected final DynamoDBOperations dynamoDBOperations;
    private final DynamoDBQueryMethod<T, ID> method;

    public AbstractDynamoDBQuery(DynamoDBOperations dynamoDBOperations, DynamoDBQueryMethod<T, ID> method) {
        this.dynamoDBOperations = dynamoDBOperations;
        this.method = method;
    }

    protected QueryExecution<T, ID> getExecution() {
        if (this.method.isCollectionQuery() && !this.isSingleEntityResultsRestriction()) {
            return new CollectionExecution();
        }
        if (this.method.isSliceQuery() && !this.isSingleEntityResultsRestriction()) {
            return new SlicedExecution(this.method.getParameters());
        }
        if (this.method.isPageQuery() && !this.isSingleEntityResultsRestriction()) {
            return new PagedExecution(this.method.getParameters());
        }
        if (this.method.isModifyingQuery()) {
            throw new UnsupportedOperationException("Modifying queries not yet supported");
        }
        if (this.isSingleEntityResultsRestriction()) {
            return new SingleEntityLimitedExecution();
        }
        if (this.isDeleteQuery()) {
            return new DeleteExecution();
        }
        return new SingleEntityExecution();
    }

    protected abstract Query<T> doCreateQuery(Object[] var1);

    protected abstract Query<Long> doCreateCountQuery(Object[] var1, boolean var2);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract Integer getResultsRestrictionIfApplicable();

    protected abstract boolean isSingleEntityResultsRestriction();

    protected Query<T> doCreateQueryWithPermissions(Object[] values) {
        Query<T> query = this.doCreateQuery(values);
        query.setScanEnabled(this.method.isScanEnabled());
        return query;
    }

    protected Query<Long> doCreateCountQueryWithPermissions(Object[] values, boolean pageQuery) {
        Query<Long> query = this.doCreateCountQuery(values, pageQuery);
        query.setScanCountEnabled(this.method.isScanCountEnabled());
        return query;
    }

    public Object execute(Object[] parameters) {
        return this.getExecution().execute(this, parameters);
    }

    public DynamoDBQueryMethod<T, ID> getQueryMethod() {
        return this.method;
    }

    class SingleEntityLimitedExecution
    implements QueryExecution<T, ID> {
        SingleEntityLimitedExecution() {
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            if (AbstractDynamoDBQuery.this.isCountQuery()) {
                return dynamoDBQuery.doCreateCountQueryWithPermissions(values, false).getSingleResult();
            }
            List resultList = dynamoDBQuery.doCreateQueryWithPermissions(values).getResultList();
            return resultList.size() == 0 ? null : resultList.get(0);
        }
    }

    class SingleEntityExecution
    implements QueryExecution<T, ID> {
        SingleEntityExecution() {
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            if (AbstractDynamoDBQuery.this.isCountQuery()) {
                return dynamoDBQuery.doCreateCountQueryWithPermissions(values, false).getSingleResult();
            }
            if (AbstractDynamoDBQuery.this.isExistsQuery()) {
                return !dynamoDBQuery.doCreateQueryWithPermissions(values).getResultList().isEmpty();
            }
            return dynamoDBQuery.doCreateQueryWithPermissions(values).getSingleResult();
        }
    }

    class DeleteExecution
    implements QueryExecution<T, ID> {
        DeleteExecution() {
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) throws BatchDeleteException {
            List entities = dynamoDBQuery.doCreateQueryWithPermissions(values).getResultList();
            List<DynamoDBMapper.FailedBatch> failedBatches = AbstractDynamoDBQuery.this.dynamoDBOperations.batchDelete(entities);
            if (failedBatches.isEmpty()) {
                return entities;
            }
            throw (BatchDeleteException)AbstractDynamoDBQuery.this.repackageToException(failedBatches, BatchDeleteException.class);
        }
    }

    class SlicedExecution
    implements QueryExecution<T, ID> {
        private final Parameters<?, ?> parameters;

        public SlicedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        private long scanThroughResults(Iterator<T> iterator, long resultsToScan) {
            long processed;
            for (processed = 0L; iterator.hasNext() && processed < resultsToScan; ++processed) {
                iterator.next();
            }
            return processed;
        }

        private List<T> readPageOfResultsRestrictMaxResultsIfNecessary(Iterator<T> iterator, int pageSize) {
            int toProcess = AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() != null ? Math.min(pageSize, AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable()) : pageSize;
            ArrayList resultsPage = new ArrayList();
            for (int processed = 0; iterator.hasNext() && processed < toProcess; ++processed) {
                resultsPage.add(iterator.next());
            }
            return resultsPage;
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            Pageable pageable = accessor.getPageable();
            Query query = dynamoDBQuery.doCreateQueryWithPermissions(values);
            List results = query.getResultList();
            return this.createSlice(results, pageable);
        }

        private Slice<T> createSlice(List<T> allResults, Pageable pageable) {
            boolean hasMoreResults;
            long processedCount;
            Iterator iterator = allResults.iterator();
            if (pageable.getOffset() > 0L && (processedCount = this.scanThroughResults(iterator, pageable.getOffset())) < pageable.getOffset()) {
                return new SliceImpl(new ArrayList());
            }
            List results = this.readPageOfResultsRestrictMaxResultsIfNecessary(iterator, pageable.getPageSize());
            boolean bl = hasMoreResults = this.scanThroughResults(iterator, 1L) > 0L;
            if (AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() != null && AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() <= results.size()) {
                hasMoreResults = false;
            }
            return new SliceImpl(results, pageable, hasMoreResults);
        }
    }

    class PagedExecution
    implements QueryExecution<T, ID> {
        private final Parameters<?, ?> parameters;

        public PagedExecution(Parameters<?, ?> parameters) {
            this.parameters = parameters;
        }

        private long scanThroughResults(Iterator<T> iterator, long resultsToScan) {
            long processed;
            for (processed = 0L; iterator.hasNext() && processed < resultsToScan; ++processed) {
                iterator.next();
            }
            return processed;
        }

        private List<T> readPageOfResultsRestrictMaxResultsIfNecessary(Iterator<T> iterator, int pageSize) {
            int toProcess = AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() != null ? Math.min(pageSize, AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable()) : pageSize;
            ArrayList resultsPage = new ArrayList();
            for (int processed = 0; iterator.hasNext() && processed < toProcess; ++processed) {
                resultsPage.add(iterator.next());
            }
            return resultsPage;
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
            Pageable pageable = accessor.getPageable();
            Query query = dynamoDBQuery.doCreateQueryWithPermissions(values);
            List results = query.getResultList();
            return this.createPage(results, pageable, dynamoDBQuery, values);
        }

        private Page<T> createPage(List<T> allResults, Pageable pageable, AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            long processedCount;
            Iterator iterator = allResults.iterator();
            if (!pageable.isUnpaged() && pageable.getOffset() > 0L && (processedCount = this.scanThroughResults(iterator, pageable.getOffset())) < pageable.getOffset()) {
                return new PageImpl(Collections.emptyList());
            }
            Query<Long> countQuery = dynamoDBQuery.doCreateCountQueryWithPermissions(values, true);
            long count = countQuery.getSingleResult();
            if (!pageable.isUnpaged()) {
                if (AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() != null) {
                    count = Math.min(count, (long)AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable().intValue());
                }
                List results = this.readPageOfResultsRestrictMaxResultsIfNecessary(iterator, pageable.getPageSize());
                return new PageImpl(results, pageable, count);
            }
            return new UnpagedPageImpl(allResults, count);
        }
    }

    class CollectionExecution
    implements QueryExecution<T, ID> {
        CollectionExecution() {
        }

        @Override
        public Object execute(AbstractDynamoDBQuery<T, ID> dynamoDBQuery, Object[] values) {
            Query query = dynamoDBQuery.doCreateQueryWithPermissions(values);
            if (AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable() != null) {
                return this.restrictMaxResultsIfNecessary(query.getResultList().iterator());
            }
            return query.getResultList();
        }

        private List<T> restrictMaxResultsIfNecessary(Iterator<T> iterator) {
            ArrayList resultsPage = new ArrayList();
            for (int processed = 0; iterator.hasNext() && processed < AbstractDynamoDBQuery.this.getResultsRestrictionIfApplicable(); ++processed) {
                resultsPage.add(iterator.next());
            }
            return resultsPage;
        }
    }

    private static interface QueryExecution<T, ID> {
        public Object execute(AbstractDynamoDBQuery<T, ID> var1, Object[] var2);
    }
}

