/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.query;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScanExpression;
import java.util.List;
import org.socialsignin.spring.data.dynamodb.core.DynamoDBOperations;
import org.socialsignin.spring.data.dynamodb.query.AbstractMultipleEntityQuery;
import org.springframework.util.Assert;

public class MultipleEntityScanExpressionQuery<T>
extends AbstractMultipleEntityQuery<T> {
    private DynamoDBScanExpression scanExpression;

    public MultipleEntityScanExpressionQuery(DynamoDBOperations dynamoDBOperations, Class<T> clazz, DynamoDBScanExpression scanExpression) {
        super(dynamoDBOperations, clazz);
        this.scanExpression = scanExpression;
    }

    @Override
    public List<T> getResultList() {
        this.assertScanEnabled(this.isScanEnabled());
        return this.dynamoDBOperations.scan(this.clazz, this.scanExpression);
    }

    public void assertScanEnabled(boolean scanEnabled) {
        Assert.isTrue((boolean)scanEnabled, (String)"Scanning for this query is not enabled.  To enable annotate your repository method with @EnableScan, or enable scanning for all repository methods by annotating your repository interface with @EnableScan");
    }
}

