/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.utils;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SortHandler {
    private SortHandler() {
    }

    public static void ensureNoSort(Pageable pageable) {
        Sort sort = pageable.getSort();
        SortHandler.ensureNoSort(sort);
    }

    public static void ensureNoSort(Sort sort) throws UnsupportedOperationException {
        if (sort != null) {
            SortHandler.throwUnsupportedSortOperationException();
        }
    }

    public static <T> T throwUnsupportedSortOperationException() {
        throw new UnsupportedOperationException("Sorting not supported for scan expressions");
    }
}

