/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.config;

import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.config.ConfigKey;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    WebDriverManager manager;
    ConfigKey<String> properties = new ConfigKey<String>("sel.jup.properties", String.class, "selenium-jupiter.properties");
    ConfigKey<String> outputFolder = new ConfigKey<String>("sel.jup.output.folder", String.class);
    ConfigKey<Boolean> outputFolderPerClass = new ConfigKey<Boolean>("sel.jup.output.folder.per.class", Boolean.class);
    ConfigKey<String> seleniumServerUrl = new ConfigKey<String>("sel.jup.selenium.server.url", String.class);
    ConfigKey<Boolean> vnc = new ConfigKey<Boolean>("sel.jup.vnc", Boolean.class);
    ConfigKey<Boolean> recording = new ConfigKey<Boolean>("sel.jup.recording", Boolean.class);
    ConfigKey<Boolean> recordingWhenFailure = new ConfigKey<Boolean>("sel.jup.recording.when.failure", Boolean.class);
    ConfigKey<Boolean> screenshot = new ConfigKey<Boolean>("sel.jup.screenshot", Boolean.class);
    ConfigKey<Boolean> screenshotWhenFailure = new ConfigKey<Boolean>("sel.jup.screenshot.when.failure", Boolean.class);
    ConfigKey<String> screenshotFormat = new ConfigKey<String>("sel.jup.screenshot.format", String.class);
    ConfigKey<String> browserTemplateJsonFile = new ConfigKey<String>("sel.jup.browser.template.json.file", String.class);
    ConfigKey<String> browserTemplateJsonContent = new ConfigKey<String>("sel.jup.browser.template.json.content", String.class);
    ConfigKey<String> reportFileName = new ConfigKey<String>("sel.jup.report.file.name", String.class);

    private <T> T resolve(ConfigKey<T> configKey) {
        String strValue = null;
        String name = configKey.getName();
        T tValue = configKey.getValue();
        Class<T> type = configKey.getType();
        strValue = System.getenv(name.toUpperCase().replace(".", "_"));
        if (strValue == null) {
            strValue = System.getProperty(name);
        }
        if (strValue == null && tValue != null) {
            return tValue;
        }
        if (strValue == null) {
            strValue = this.getProperty(name);
        }
        return this.parse(type, strValue);
    }

    private <T> T parse(Class<T> type, String strValue) {
        Object output = null;
        if (type.equals(String.class)) {
            output = strValue;
        } else if (type.equals(Integer.class)) {
            output = Integer.valueOf(strValue);
        } else if (type.equals(Boolean.class)) {
            output = Boolean.valueOf(strValue);
        } else {
            throw new SeleniumJupiterException("Type " + type.getTypeName() + " cannot be parsed");
        }
        return (T)output;
    }

    private String getProperty(String key) {
        String value = null;
        Properties props = new Properties();
        try {
            InputStream inputStream = Config.class.getResourceAsStream("/" + this.getProperties());
            props.load(inputStream);
            value = props.getProperty(key);
        }
        catch (Exception e) {
            throw new SeleniumJupiterException(e);
        }
        finally {
            if (value == null) {
                this.log.trace("Property key {} not found, using default value", (Object)key);
                value = "";
            }
        }
        return value;
    }

    public void reset() {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.getType() != ConfigKey.class) continue;
            try {
                ((ConfigKey)field.get(this)).reset();
            }
            catch (Exception e) {
                this.log.warn("Exception reseting {}", (Object)field);
            }
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public String getProperties() {
        return this.resolve(this.properties);
    }

    public void setProperties(String properties) {
        this.properties.setValue(properties);
    }

    public String getSeleniumServerUrl() {
        String url = this.resolve(this.seleniumServerUrl);
        if (Config.isNullOrEmpty(url)) {
            url = System.getProperty("webdriver.remote.server");
        }
        return url;
    }

    public void setSeleniumServerUrl(String value) {
        this.seleniumServerUrl.setValue(value);
    }

    public String getOutputFolder() {
        return this.resolve(this.outputFolder);
    }

    public void setOutputFolder(String value) {
        this.outputFolder.setValue(value);
    }

    public boolean isOutputFolderPerClass() {
        return this.resolve(this.outputFolderPerClass);
    }

    public void setOutputFolderPerClass(boolean value) {
        this.outputFolderPerClass.setValue(value);
    }

    public boolean isVnc() {
        return this.resolve(this.vnc);
    }

    public void setVnc(boolean value) {
        this.vnc.setValue(value);
    }

    public boolean isRecording() {
        return this.resolve(this.recording);
    }

    public void setRecording(boolean value) {
        this.recording.setValue(value);
    }

    public boolean isRecordingWhenFailure() {
        return this.resolve(this.recordingWhenFailure);
    }

    public void setRecordingWhenFailure(boolean value) {
        this.recordingWhenFailure.setValue(value);
    }

    public boolean isScreenshot() {
        return this.resolve(this.screenshot);
    }

    public void setScreenshot(boolean value) {
        this.screenshot.setValue(value);
    }

    public boolean isScreenshotWhenFailure() {
        return this.resolve(this.screenshotWhenFailure);
    }

    public void setScreenshotWhenFailure(boolean value) {
        this.screenshotWhenFailure.setValue(value);
    }

    public String getScreenshotFormat() {
        return this.resolve(this.screenshotFormat);
    }

    public void setScreenshotFormat(String value) {
        this.screenshotFormat.setValue(value);
    }

    public String getBrowserTemplateJsonFile() {
        return this.resolve(this.browserTemplateJsonFile);
    }

    public void setBrowserTemplateJsonFile(String value) {
        this.browserTemplateJsonFile.setValue(value);
    }

    public String getBrowserTemplateJsonContent() {
        return this.resolve(this.browserTemplateJsonContent);
    }

    public void setBrowserTemplateJsonContent(String value) {
        this.browserTemplateJsonContent.setValue(value);
    }

    public String getReportFileName() {
        return this.resolve(this.reportFileName);
    }

    public void setReportFileName(String value) {
        this.reportFileName.setValue(value);
    }

    public WebDriverManager getManager() {
        return this.manager;
    }

    public void setManager(WebDriverManager manager) {
        this.manager = manager;
    }

    public void enableVnc() {
        this.setVnc(true);
    }

    public void enableScreenshot() {
        this.setScreenshot(true);
    }

    public void enableRecording() {
        this.setRecording(true);
    }

    public void enableRecordingWhenFailure() {
        this.setRecordingWhenFailure(true);
    }

    public void enableScreenshotWhenFailure() {
        this.setScreenshotWhenFailure(true);
    }

    public void useSurefireOutputFolder() {
        this.setOutputFolder("surefire-reports");
    }

    public void takeScreenshotAsBase64() {
        this.setScreenshotFormat("base64");
    }

    public void takeScreenshotAsPng() {
        this.setScreenshotFormat("png");
    }

    public void takeScreenshotAsBase64AndPng() {
        this.setScreenshotFormat("base64andpng");
    }
}

