/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.DriverCapabilities;
import io.github.bonigarcia.seljup.DriverUrl;
import io.github.bonigarcia.seljup.Opera;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.Watch;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsReader {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Optional<Capabilities> getCapabilities(Parameter parameter, Optional<Object> testInstance) {
        Optional<Capabilities> out = Optional.empty();
        try {
            DriverCapabilities driverCapabilities = parameter.getAnnotation(DriverCapabilities.class);
            DesiredCapabilities capabilities = null;
            if (driverCapabilities != null) {
                capabilities = new DesiredCapabilities();
                for (String capability : driverCapabilities.value()) {
                    Optional<List<Object>> keyValue = this.getKeyValue(capability);
                    if (!keyValue.isPresent()) continue;
                    capabilities.setCapability(keyValue.get().get(0).toString(), keyValue.get().get(1));
                }
                out = Optional.of(capabilities);
            } else {
                Optional<Object> annotatedField = this.seekFieldAnnotatedWith(testInstance, DriverCapabilities.class);
                if (annotatedField.isPresent()) {
                    capabilities = (Capabilities)annotatedField.get();
                    out = Optional.of(capabilities);
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception getting capabilities", (Throwable)e);
        }
        return out;
    }

    public Optional<URL> getUrl(Parameter parameter, Optional<Object> testInstance, String seleniumServerUrl) {
        Optional<URL> out = Optional.empty();
        try {
            if (seleniumServerUrl != null && !seleniumServerUrl.isEmpty()) {
                out = Optional.of(new URL(seleniumServerUrl));
            } else {
                Object urlValue = null;
                DriverUrl driverUrl = parameter.getAnnotation(DriverUrl.class);
                if (driverUrl != null) {
                    urlValue = driverUrl.value();
                    out = Optional.of(new URL(urlValue.toString()));
                } else {
                    Optional<Object> annotatedField = this.seekFieldAnnotatedWith(testInstance, DriverUrl.class);
                    if (annotatedField.isPresent()) {
                        urlValue = annotatedField.get();
                        out = Optional.of(new URL(urlValue.toString()));
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception getting URL", (Throwable)e);
        }
        return out;
    }

    public boolean isBoolean(String s) {
        boolean isBool;
        boolean bl = isBool = s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
        if (!isBool) {
            log.trace("Value {} is not boolean", (Object)s);
        }
        return isBool;
    }

    public boolean isNumeric(String s) {
        boolean numeric = StringUtils.isNumeric((CharSequence)s);
        if (!numeric) {
            log.trace("Value {} is not numeric", (Object)s);
        }
        return numeric;
    }

    public <T> T getFromAnnotatedField(Optional<Object> testInstance, Class<? extends Annotation> annotationClass, Class<T> capabilitiesClass) {
        if (capabilitiesClass == null) {
            throw new SeleniumJupiterException("The parameter capabilitiesClass must not be null");
        }
        return AnnotationsReader.seekFieldAnnotatedWith(testInstance, annotationClass, capabilitiesClass).orElse(null);
    }

    public Optional<Object> seekFieldAnnotatedWith(Optional<Object> testInstance, Class<? extends Annotation> annotation) {
        return AnnotationsReader.seekFieldAnnotatedWith(testInstance, annotation, null);
    }

    private static <T> Optional<T> seekFieldAnnotatedWith(Optional<Object> testInstance, Class<? extends Annotation> annotation, Class<T> annotatedType) {
        Optional out = Optional.empty();
        try {
            Object object;
            Class<?> clazz;
            if (testInstance.isPresent() && !(out = AnnotationsReader.getField(annotation, annotatedType, clazz = (object = testInstance.get()).getClass(), object)).isPresent()) {
                Optional<T> field;
                Class<?> superclass;
                while ((superclass = clazz.getSuperclass()) != Object.class && !(out = (field = AnnotationsReader.getField(annotation, annotatedType, superclass, object))).isPresent()) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception seeking field in {} annotated with {}", new Object[]{annotatedType, annotation, e});
        }
        return out;
    }

    private static <T> Optional<T> getField(Class<? extends Annotation> annotation, Class<T> annotatedType, Class<? extends Object> clazz, Object object) throws IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation) || annotatedType != null && !annotatedType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            if (annotatedType != null) {
                return Optional.ofNullable(annotatedType.cast(field.get(object)));
            }
            return Optional.ofNullable(field.get(object));
        }
        return Optional.empty();
    }

    public boolean getOpera(Parameter parameter) {
        return parameter.getAnnotation(Opera.class) != null;
    }

    public Optional<DockerBrowser> getDocker(Parameter parameter) {
        Optional<DockerBrowser> out = Optional.empty();
        DockerBrowser dockerBrowser = parameter.getAnnotation(DockerBrowser.class);
        if (dockerBrowser != null) {
            out = Optional.of(dockerBrowser);
        }
        return out;
    }

    public Optional<Watch> getWatch(Parameter parameter) {
        Optional<Watch> out = Optional.empty();
        Watch watch = parameter.getAnnotation(Watch.class);
        if (watch != null) {
            out = Optional.of(watch);
        }
        return out;
    }

    public Optional<List<Object>> getKeyValue(String keyValue) {
        StringTokenizer st = new StringTokenizer(keyValue, "=");
        if (st.countTokens() != 2) {
            log.warn("Invalid format in {} (expected key=value)", (Object)keyValue);
            return Optional.empty();
        }
        String key = st.nextToken();
        String value = st.nextToken();
        Object returnedValue = value;
        if (this.isBoolean(value)) {
            returnedValue = Boolean.valueOf(value);
        } else if (this.isNumeric(value)) {
            returnedValue = Integer.valueOf(value);
        }
        return Optional.of(Arrays.asList(key, returnedValue));
    }
}

