/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.stream.model;

import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.stream.JSON;
import com.binance.connector.client.spot.websocket.stream.model.Levels;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PartialBookDepthRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nonnull
    private String symbol;
    public static final String SERIALIZED_NAME_LEVELS = "levels";
    @SerializedName(value="levels")
    @Nonnull
    private Levels levels;
    public static final String SERIALIZED_NAME_UPDATE_SPEED = "updateSpeed";
    @SerializedName(value="updateSpeed")
    @Nullable
    private String updateSpeed;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PartialBookDepthRequest symbol(@Nonnull String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nonnull String symbol) {
        this.symbol = symbol;
    }

    public PartialBookDepthRequest levels(@Nonnull Levels levels) {
        this.levels = levels;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Levels getLevels() {
        return this.levels;
    }

    public void setLevels(@Nonnull Levels levels) {
        this.levels = levels;
    }

    public PartialBookDepthRequest updateSpeed(@Nullable String updateSpeed) {
        this.updateSpeed = updateSpeed;
        return this;
    }

    @Nullable
    public String getUpdateSpeed() {
        return this.updateSpeed;
    }

    public void setUpdateSpeed(@Nullable String updateSpeed) {
        this.updateSpeed = updateSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PartialBookDepthRequest partialBookDepthRequest = (PartialBookDepthRequest)((Object)o);
        return Objects.equals(this.symbol, partialBookDepthRequest.symbol) && Objects.equals((Object)this.levels, (Object)partialBookDepthRequest.levels) && Objects.equals(this.updateSpeed, partialBookDepthRequest.updateSpeed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.levels, this.updateSpeed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartialBookDepthRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\tlevels: ").append(this.toIndentedString((Object)this.levels)).append("\n");
        sb.append("\t\tupdateSpeed: ").append(this.toIndentedString(this.updateSpeed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        String updateSpeedValue;
        Levels levelsValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((levelsValue = this.getLevels()) != null) {
            String levelsValueAsString = levelsValue.toString();
            valMap.put(SERIALIZED_NAME_LEVELS, levelsValueAsString);
        }
        if ((updateSpeedValue = this.getUpdateSpeed()) != null) {
            String updateSpeedValueAsString = updateSpeedValue.toString();
            valMap.put(SERIALIZED_NAME_UPDATE_SPEED, updateSpeedValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return PartialBookDepthRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        String updateSpeedValue;
        Levels levelsValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((levelsValue = this.getLevels()) != null) {
            valMap.put(SERIALIZED_NAME_LEVELS, (Object)levelsValue);
        }
        if ((updateSpeedValue = this.getUpdateSpeed()) != null) {
            valMap.put(SERIALIZED_NAME_UPDATE_SPEED, updateSpeedValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PartialBookDepthRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PartialBookDepthRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        Levels.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LEVELS));
        if (jsonObj.get(SERIALIZED_NAME_UPDATE_SPEED) != null && !jsonObj.get(SERIALIZED_NAME_UPDATE_SPEED).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UPDATE_SPEED).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `updateSpeed` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UPDATE_SPEED).toString()));
        }
    }

    public static PartialBookDepthRequest fromJson(String jsonString) throws IOException {
        return (PartialBookDepthRequest)((Object)JSON.getGson().fromJson(jsonString, PartialBookDepthRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_LEVELS);
        openapiFields.add(SERIALIZED_NAME_UPDATE_SPEED);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_LEVELS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PartialBookDepthRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PartialBookDepthRequest.class));
            return new TypeAdapter<PartialBookDepthRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, PartialBookDepthRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PartialBookDepthRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (PartialBookDepthRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

