/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.stream.model;

import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.stream.JSON;
import com.binance.connector.client.spot.websocket.stream.model.Interval;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class KlineOffsetRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nonnull
    private String symbol;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    @Nonnull
    private Interval interval;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public KlineOffsetRequest symbol(@Nonnull String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nonnull String symbol) {
        this.symbol = symbol;
    }

    public KlineOffsetRequest interval(@Nonnull Interval interval) {
        this.interval = interval;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(@Nonnull Interval interval) {
        this.interval = interval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KlineOffsetRequest klineOffsetRequest = (KlineOffsetRequest)((Object)o);
        return Objects.equals(this.symbol, klineOffsetRequest.symbol) && Objects.equals((Object)this.interval, (Object)klineOffsetRequest.interval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.interval});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KlineOffsetRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\tinterval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        Interval intervalValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((intervalValue = this.getInterval()) != null) {
            String intervalValueAsString = intervalValue.toString();
            valMap.put(SERIALIZED_NAME_INTERVAL, intervalValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return KlineOffsetRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        Interval intervalValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((intervalValue = this.getInterval()) != null) {
            valMap.put(SERIALIZED_NAME_INTERVAL, (Object)intervalValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in KlineOffsetRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KlineOffsetRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        Interval.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTERVAL));
    }

    public static KlineOffsetRequest fromJson(String jsonString) throws IOException {
        return (KlineOffsetRequest)((Object)JSON.getGson().fromJson(jsonString, KlineOffsetRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_INTERVAL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_INTERVAL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!KlineOffsetRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KlineOffsetRequest.class));
            return new TypeAdapter<KlineOffsetRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, KlineOffsetRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public KlineOffsetRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (KlineOffsetRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

