/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.stream.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum Interval {
    INTERVAL_1s("1s"),
    INTERVAL_1m("1m"),
    INTERVAL_3m("3m"),
    INTERVAL_5m("5m"),
    INTERVAL_15m("15m"),
    INTERVAL_30m("30m"),
    INTERVAL_1h("1h"),
    INTERVAL_2h("2h"),
    INTERVAL_4h("4h"),
    INTERVAL_6h("6h"),
    INTERVAL_8h("8h"),
    INTERVAL_12h("12h"),
    INTERVAL_1d("1d"),
    INTERVAL_3d("3d"),
    INTERVAL_1w("1w"),
    INTERVAL_1M("1M");

    private String value;

    private Interval(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Interval fromValue(String value) {
        for (Interval b : Interval.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        Interval.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<Interval> {
        public void write(JsonWriter jsonWriter, Interval enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public Interval read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return Interval.fromValue(value);
        }
    }
}

