/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.spot.websocket.api.model.AvgPriceRequest;
import com.binance.connector.client.spot.websocket.api.model.AvgPriceResponse;
import com.binance.connector.client.spot.websocket.api.model.DepthRequest;
import com.binance.connector.client.spot.websocket.api.model.DepthResponse;
import com.binance.connector.client.spot.websocket.api.model.KlinesRequest;
import com.binance.connector.client.spot.websocket.api.model.KlinesResponse;
import com.binance.connector.client.spot.websocket.api.model.Ticker24hrRequest;
import com.binance.connector.client.spot.websocket.api.model.Ticker24hrResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerBookRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerBookResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerPriceRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerPriceResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerTradingDayRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerTradingDayResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesAggregateRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesAggregateResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesHistoricalRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesHistoricalResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesRecentRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesRecentResponse;
import com.binance.connector.client.spot.websocket.api.model.UiKlinesRequest;
import com.binance.connector.client.spot.websocket.api.model.UiKlinesResponse;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class MarketApi {
    private ConnectionInterface connection;

    public MarketApi() {
    }

    public MarketApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<AvgPriceResponse> avgPrice(AvgPriceRequest avgPriceRequest) throws ApiException {
        this.avgPriceValidateBeforeCall(avgPriceRequest);
        String methodName = "/avgPrice".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)avgPriceRequest).responseType(AvgPriceResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void avgPriceValidateBeforeCall(AvgPriceRequest avgPriceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)avgPriceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<DepthResponse> depth(DepthRequest depthRequest) throws ApiException {
        this.depthValidateBeforeCall(depthRequest);
        String methodName = "/depth".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)depthRequest).responseType(DepthResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void depthValidateBeforeCall(DepthRequest depthRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)depthRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<KlinesResponse> klines(KlinesRequest klinesRequest) throws ApiException {
        this.klinesValidateBeforeCall(klinesRequest);
        String methodName = "/klines".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)klinesRequest).responseType(KlinesResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void klinesValidateBeforeCall(KlinesRequest klinesRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)klinesRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TickerResponse> ticker(TickerRequest tickerRequest) throws ApiException {
        this.tickerValidateBeforeCall(tickerRequest);
        String methodName = "/ticker".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tickerRequest).responseType(TickerResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tickerValidateBeforeCall(TickerRequest tickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<Ticker24hrResponse> ticker24hr(Ticker24hrRequest ticker24hrRequest) throws ApiException {
        this.ticker24hrValidateBeforeCall(ticker24hrRequest);
        String methodName = "/ticker.24hr".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)ticker24hrRequest).responseType(Ticker24hrResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void ticker24hrValidateBeforeCall(Ticker24hrRequest ticker24hrRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)ticker24hrRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TickerBookResponse> tickerBook(TickerBookRequest tickerBookRequest) throws ApiException {
        this.tickerBookValidateBeforeCall(tickerBookRequest);
        String methodName = "/ticker.book".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tickerBookRequest).responseType(TickerBookResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tickerBookValidateBeforeCall(TickerBookRequest tickerBookRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tickerBookRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TickerPriceResponse> tickerPrice(TickerPriceRequest tickerPriceRequest) throws ApiException {
        this.tickerPriceValidateBeforeCall(tickerPriceRequest);
        String methodName = "/ticker.price".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tickerPriceRequest).responseType(TickerPriceResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tickerPriceValidateBeforeCall(TickerPriceRequest tickerPriceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tickerPriceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TickerTradingDayResponse> tickerTradingDay(TickerTradingDayRequest tickerTradingDayRequest) throws ApiException {
        this.tickerTradingDayValidateBeforeCall(tickerTradingDayRequest);
        String methodName = "/ticker.tradingDay".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tickerTradingDayRequest).responseType(TickerTradingDayResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tickerTradingDayValidateBeforeCall(TickerTradingDayRequest tickerTradingDayRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tickerTradingDayRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TradesAggregateResponse> tradesAggregate(TradesAggregateRequest tradesAggregateRequest) throws ApiException {
        this.tradesAggregateValidateBeforeCall(tradesAggregateRequest);
        String methodName = "/trades.aggregate".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tradesAggregateRequest).responseType(TradesAggregateResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tradesAggregateValidateBeforeCall(TradesAggregateRequest tradesAggregateRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tradesAggregateRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TradesHistoricalResponse> tradesHistorical(TradesHistoricalRequest tradesHistoricalRequest) throws ApiException {
        this.tradesHistoricalValidateBeforeCall(tradesHistoricalRequest);
        String methodName = "/trades.historical".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tradesHistoricalRequest).responseType(TradesHistoricalResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tradesHistoricalValidateBeforeCall(TradesHistoricalRequest tradesHistoricalRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tradesHistoricalRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<TradesRecentResponse> tradesRecent(TradesRecentRequest tradesRecentRequest) throws ApiException {
        this.tradesRecentValidateBeforeCall(tradesRecentRequest);
        String methodName = "/trades.recent".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)tradesRecentRequest).responseType(TradesRecentResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void tradesRecentValidateBeforeCall(TradesRecentRequest tradesRecentRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tradesRecentRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<UiKlinesResponse> uiKlines(UiKlinesRequest uiKlinesRequest) throws ApiException {
        this.uiKlinesValidateBeforeCall(uiKlinesRequest);
        String methodName = "/uiKlines".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)uiKlinesRequest).responseType(UiKlinesResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void uiKlinesValidateBeforeCall(UiKlinesRequest uiKlinesRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)uiKlinesRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

